/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.schedule.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ScheduleJsonCodec
implements JsonCodec<Schedule> {
    @NonNull
    public Schedule parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            ScheduleID temp_schedule_id = null;
            boolean temp_deleted = false;
            boolean temp_executed = false;
            boolean temp_wait_for_expiry = false;
            String temp_memo = "";
            AccountID temp_scheduler_account_id = null;
            AccountID temp_payer_account_id = null;
            Key temp_admin_key = null;
            Timestamp temp_schedule_valid_start = null;
            long temp_provided_expiration_second = 0L;
            long temp_calculated_expiration_second = 0L;
            Timestamp temp_resolution_time = null;
            SchedulableTransactionBody temp_scheduled_transaction = null;
            TransactionBody temp_original_create_transaction = null;
            List temp_signatories = Collections.emptyList();
            block36: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "scheduleId": {
                        temp_schedule_id = (ScheduleID)ScheduleID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "deleted": {
                        temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "executed": {
                        temp_executed = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "waitForExpiry": {
                        temp_wait_for_expiry = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)JsonTools.checkSize((String)"memo", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block36;
                    }
                    case "schedulerAccountId": {
                        temp_scheduler_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "payerAccountId": {
                        temp_payer_account_id = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "adminKey": {
                        temp_admin_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "scheduleValidStart": {
                        temp_schedule_valid_start = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "providedExpirationSecond": {
                        temp_provided_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "calculatedExpirationSecond": {
                        temp_calculated_expiration_second = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "resolutionTime": {
                        temp_resolution_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "scheduledTransaction": {
                        temp_scheduled_transaction = (SchedulableTransactionBody)SchedulableTransactionBody.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "originalCreateTransaction": {
                        temp_original_create_transaction = (TransactionBody)TransactionBody.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block36;
                    }
                    case "signatories": {
                        temp_signatories = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"signatories", (List)kvPair.value().arr().value(), (int)maxSize), Key.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block36;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Schedule(temp_schedule_id, temp_deleted, temp_executed, temp_wait_for_expiry, temp_memo, temp_scheduler_account_id, temp_payer_account_id, temp_admin_key, temp_schedule_valid_start, temp_provided_expiration_second, temp_calculated_expiration_second, temp_resolution_time, temp_scheduled_transaction, temp_original_create_transaction, temp_signatories);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Schedule data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.scheduleId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleId", ScheduleID.JSON, (Object)data.scheduleId()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (data.executed()) {
            fieldLines.add(JsonTools.field((String)"executed", (boolean)data.executed()));
        }
        if (data.waitForExpiry()) {
            fieldLines.add(JsonTools.field((String)"waitForExpiry", (boolean)data.waitForExpiry()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.schedulerAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"schedulerAccountId", AccountID.JSON, (Object)data.schedulerAccountId()));
        }
        if (data.payerAccountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"payerAccountId", AccountID.JSON, (Object)data.payerAccountId()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.scheduleValidStart() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleValidStart", Timestamp.JSON, (Object)data.scheduleValidStart()));
        }
        if (data.providedExpirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"providedExpirationSecond", (long)data.providedExpirationSecond()));
        }
        if (data.calculatedExpirationSecond() != 0L) {
            fieldLines.add(JsonTools.field((String)"calculatedExpirationSecond", (long)data.calculatedExpirationSecond()));
        }
        if (data.resolutionTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"resolutionTime", Timestamp.JSON, (Object)data.resolutionTime()));
        }
        if (data.scheduledTransaction() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduledTransaction", SchedulableTransactionBody.JSON, (Object)data.scheduledTransaction()));
        }
        if (data.originalCreateTransaction() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"originalCreateTransaction", TransactionBody.JSON, (Object)data.originalCreateTransaction()));
        }
        if (!data.signatories().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"signatories", Key.JSON, data.signatories()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

