/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.util;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.test.fixtures.dummy.Key;
import com.swirlds.common.test.fixtures.dummy.Value;
import com.swirlds.merkle.test.fixtures.map.dummy.FCQValue;
import com.swirlds.merkle.test.fixtures.map.util.MapMutatorSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public enum KeyValueProvider {
    KEY_VALUE(MapMutatorSet.ValueType.SIMPLE, () -> new Key(1L, 1L, 1L), () -> Value.newBuilder().setReceiveThresholdValue(12345L).setSendThresholdvalue(54321L).setBalance(98766L).setReceiveSignatureRequired(true).build(), index -> new Key((long)index.intValue(), (long)index.intValue(), (long)index.intValue()), Value::buildRandomValue),
    KEY_FCQ(MapMutatorSet.ValueType.FCQ, () -> new Key(1L, 1L, 1L), FCQValue::buildDefault, index -> new Key((long)index.intValue(), (long)index.intValue(), (long)index.intValue()), FCQValue::buildRandom);

    private final MapMutatorSet mapMutatorSet;
    private final Supplier<Key> defaultKey;
    private final Supplier<MerkleNode> defaultValue;
    private final Function<Integer, Key> keyFactory;
    private final Supplier<MerkleNode> randomValueFactory;

    private <V extends MerkleNode> KeyValueProvider(MapMutatorSet.ValueType valueType, Supplier<Key> defaultKey, Supplier<V> defaultValue, Function<Integer, Key> keyFactory, Supplier<V> randomValueFactory) {
        this.mapMutatorSet = new MapMutatorSet(valueType);
        this.defaultKey = defaultKey;
        this.defaultValue = defaultValue;
        this.keyFactory = keyFactory;
        this.randomValueFactory = randomValueFactory;
    }

    public <V extends MerkleNode> void insertIntoMap(int startIndex, int endIndex, Map<Key, V> fcm) {
        this.mapMutatorSet.insertIntoMap(startIndex, endIndex, fcm);
    }

    public <V extends MerkleNode & Keyed<Key>> void updateMap(Map<Key, V> fcm, int percentage) {
        this.mapMutatorSet.updateValueInMap(fcm, percentage);
    }

    public <V extends MerkleNode & Keyed<Key>> void deleteFromMap(Map<Key, V> fcm, int percentage) {
        this.mapMutatorSet.deleteFromMap(fcm, percentage);
    }

    public Key getDefaultKey() {
        return this.defaultKey.get();
    }

    public <V extends MerkleNode> V getDefaultValue() {
        return (V)this.defaultValue.get();
    }

    public Key getKeyBasedOnIndex(int index) {
        return this.keyFactory.apply(index);
    }

    public <V extends MerkleNode> V buildRandomValue() {
        return (V)this.randomValueFactory.get();
    }
}

