/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.sequence.map;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.ToLongFunction;
import org.hiero.base.concurrent.locks.IndexLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.consensus.model.sequence.map.AbstractSequenceMap;

public class ConcurrentSequenceMap<K, V>
extends AbstractSequenceMap<K, V> {
    private static final int MAX_PARALLELISM = 1024;
    private final AtomicLong firstSequenceNumberInWindow;
    private final int parallelism;
    private final IndexLock lock;
    private final Lock windowLock = new ReentrantLock();

    public ConcurrentSequenceMap(long firstSequenceNumberInWindow, int sequenceNumberCapacity, @NonNull ToLongFunction<K> getSequenceNumberFromKey) {
        this(firstSequenceNumberInWindow, sequenceNumberCapacity, false, getSequenceNumberFromKey);
    }

    public ConcurrentSequenceMap(long firstSequenceNumberInWindow, int sequenceNumberCapacity, boolean allowExpansion, @NonNull ToLongFunction<K> getSequenceNumberFromKey) {
        super(firstSequenceNumberInWindow, sequenceNumberCapacity, allowExpansion, getSequenceNumberFromKey);
        this.parallelism = Math.min(1024, sequenceNumberCapacity);
        this.lock = Locks.createIndexLock((int)this.parallelism);
        this.firstSequenceNumberInWindow = new AtomicLong(firstSequenceNumberInWindow);
    }

    @Override
    protected void lockSequenceNumber(long sequenceNumber) {
        this.lock.lock(sequenceNumber);
    }

    @Override
    protected void unlockSequenceNumber(long sequenceNumber) {
        this.lock.unlock(sequenceNumber);
    }

    @Override
    protected void fullLock() {
        this.lock.fullyLock();
    }

    @Override
    protected void fullUnlock() {
        this.lock.fullyUnlock();
    }

    @Override
    protected int getFullLockThreshold() {
        return this.parallelism;
    }

    @Override
    protected void windowLock() {
        this.windowLock.lock();
    }

    @Override
    protected void windowUnlock() {
        this.windowLock.unlock();
    }

    @Override
    public long getFirstSequenceNumberInWindow() {
        return this.firstSequenceNumberInWindow.get();
    }

    @Override
    protected void setFirstSequenceNumberInWindow(long firstSequenceNumberInWindow) {
        this.firstSequenceNumberInWindow.set(firstSequenceNumberInWindow);
    }

    @Override
    protected Map<K, V> buildDataMap() {
        return new ConcurrentHashMap();
    }
}

