/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility.test.fixtures;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Random;
import org.hiero.base.utility.test.fixtures.ResettableRandom;

public class RandomUtils {
    private static final Random RANDOM = new SecureRandom();

    private RandomUtils() {
    }

    @NonNull
    public static String randomString(@NonNull Random random, int length) {
        int LEFT_LIMIT = 48;
        int RIGHT_LIMIT = 122;
        return random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    @NonNull
    public static String randomIp(@NonNull Random r) {
        return r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256) + "." + r.nextInt(256);
    }

    public static long randomPositiveLong(@NonNull Random random, long maxValue) {
        return random.longs(1L, 1L, maxValue).findFirst().orElseThrow();
    }

    public static long randomPositiveLong(@NonNull Random random) {
        return RandomUtils.randomPositiveLong(random, Long.MAX_VALUE);
    }

    @NonNull
    public static byte[] randomByteArray(@NonNull Random random, int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    @NonNull
    public static Instant randomInstant(@NonNull Random random) {
        return Instant.ofEpochMilli(RandomUtils.randomPositiveLong(random, 2000000000000L));
    }

    public static boolean randomBooleanWithProbability(@NonNull Random random, double trueProbability) {
        return random.nextDouble() < trueProbability;
    }

    @NonNull
    public static ResettableRandom getRandomPrintSeed() {
        return RandomUtils.getRandom(true);
    }

    @NonNull
    public static ResettableRandom getRandomPrintSeed(long seed) {
        System.out.println("Random seed: " + seed + "L");
        return new ResettableRandom(seed);
    }

    @NonNull
    public static ResettableRandom getRandom() {
        return RandomUtils.getRandom(false);
    }

    @NonNull
    public static ResettableRandom getRandom(boolean printSeed) {
        return RandomUtils.createRandom(RANDOM.nextLong(), printSeed);
    }

    @NonNull
    private static ResettableRandom createRandom(long seed, boolean printSeed) {
        if (printSeed) {
            System.out.println("Random seed: " + seed + "L");
        }
        return new ResettableRandom(seed);
    }

    @NonNull
    public static ResettableRandom initRandom(@Nullable Long seed) {
        return RandomUtils.initRandom(seed, true);
    }

    @NonNull
    public static ResettableRandom initRandom(@Nullable Long seed, boolean printSeed) {
        if (seed == null) {
            return RandomUtils.getRandomPrintSeed();
        }
        return RandomUtils.createRandom(seed, printSeed);
    }

    public static int nextInt() {
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        if (endExclusive < startInclusive) {
            throw new IllegalArgumentException("Start value must be smaller or equal to end value.");
        }
        if (startInclusive < 0) {
            throw new IllegalArgumentException("Both range values must be non-negative.");
        }
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RANDOM.nextInt(endExclusive - startInclusive);
    }

    public static long nextLong(long startInclusive, long endExclusive) {
        if (endExclusive < startInclusive) {
            throw new IllegalArgumentException("Start value must be smaller or equal to end value.");
        }
        if (startInclusive < 0L) {
            throw new IllegalArgumentException("Both range values must be non-negative.");
        }
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RandomUtils.nextLong(endExclusive - startInclusive);
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = RANDOM.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static long nextLong() {
        return RandomUtils.nextLong(Long.MAX_VALUE);
    }
}

