/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.FastCopyable;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class AccountID
implements SelfSerializable,
FastCopyable {
    private static final long CLASS_ID = 2459990738808562462L;
    private long shardNum;
    private long realmNum;
    private long accountNum;
    private transient boolean deleted;
    private boolean immutable;

    public AccountID() {
    }

    AccountID(long shardNum, long realmNum, long accountNum) {
        this.shardNum = shardNum;
        this.realmNum = realmNum;
        this.accountNum = accountNum;
    }

    private AccountID(AccountID key) {
        this.shardNum = key.shardNum;
        this.realmNum = key.realmNum;
        this.accountNum = key.accountNum;
        this.deleted = key.deleted;
    }

    public AccountID deepCopy() {
        return new AccountID(this.shardNum, this.realmNum, this.accountNum);
    }

    public AccountID copy() {
        this.throwIfImmutable();
        return new AccountID(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (this.deleted) {
            throw new IllegalStateException("Trying to serialize a deleted AccountId");
        }
        out.writeLong(this.shardNum);
        out.writeLong(this.realmNum);
        out.writeLong(this.accountNum);
    }

    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.shardNum = inStream.readLong();
        this.realmNum = inStream.readLong();
        this.accountNum = inStream.readLong();
    }

    public boolean release() {
        this.deleted = true;
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountID)) {
            return false;
        }
        AccountID accountID = (AccountID)o;
        return this.shardNum == accountID.shardNum && this.realmNum == accountID.realmNum && this.accountNum == accountID.accountNum;
    }

    public int hashCode() {
        return Objects.hash(this.shardNum, this.realmNum, this.accountNum);
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.shardNum, this.realmNum, this.accountNum);
    }

    static AccountID generateRandom(Random random) {
        long shardNum = random.nextLong();
        long realmNum = random.nextLong();
        long accountNum = random.nextLong();
        return new AccountID(shardNum, realmNum, accountNum);
    }

    public long getClassId() {
        return 2459990738808562462L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

