/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.plugins;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mockito.NotExtensible;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.DoNotMockEnforcerWithType;

public interface DoNotMockEnforcer
extends DoNotMockEnforcerWithType {
    public String checkTypeForDoNotMockViolation(Class<?> var1);

    @Override
    default public String checkTypeForDoNotMockViolation(MockCreationSettings<?> creationSettings) {
        String warning = this.recursiveCheckDoNotMockAnnotationForType(creationSettings.getTypeToMock());
        if (warning != null) {
            return warning;
        }
        for (Class<?> aClass : creationSettings.getExtraInterfaces()) {
            warning = this.recursiveCheckDoNotMockAnnotationForType(aClass);
            if (warning == null) continue;
            return warning;
        }
        return null;
    }

    private String recursiveCheckDoNotMockAnnotationForType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (Cache.MOCKABLE_TYPES.contains(type)) {
            return null;
        }
        String warning = this.checkTypeForDoNotMockViolation(type);
        if (warning != null) {
            return warning;
        }
        warning = this.recursiveCheckDoNotMockAnnotationForType(type.getSuperclass());
        if (warning != null) {
            return warning;
        }
        for (Class<?> aClass : type.getInterfaces()) {
            warning = this.recursiveCheckDoNotMockAnnotationForType(aClass);
            if (warning == null) continue;
            return warning;
        }
        Cache.MOCKABLE_TYPES.add(type);
        return null;
    }

    @NotExtensible
    public static class Cache {
        private static final Set<Class<?>> MOCKABLE_TYPES = ConcurrentHashMap.newKeySet();
    }
}

