/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.FastCopyable;
import com.swirlds.demo.migration.AccountID;
import com.swirlds.demo.migration.FCTimestamp;
import com.swirlds.demo.migration.TransactionHash;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.crypto.AbstractSerializableHashable;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class TransactionRecord
extends AbstractSerializableHashable
implements FastCopyable {
    private static final long CLASS_ID = -8435811711067532216L;
    private String status;
    private AccountID accountID;
    private AccountID fileID;
    private AccountID contractID;
    private FCTimestamp timestamp;
    private TransactionHash transactionHash;
    private boolean deleted;
    private boolean immutable;

    private TransactionRecord(String status, AccountID accountID, AccountID fileID, AccountID contractID, FCTimestamp timestamp, TransactionHash transactionHash) {
        this.status = status;
        this.accountID = accountID;
        this.fileID = fileID;
        this.contractID = contractID;
        this.timestamp = timestamp;
        this.transactionHash = transactionHash;
    }

    private TransactionRecord(TransactionRecord transactionRecord) {
        this.status = transactionRecord.status;
        this.accountID = transactionRecord.accountID.copy();
        this.fileID = transactionRecord.fileID.copy();
        this.contractID = transactionRecord.contractID.copy();
        this.timestamp = transactionRecord.timestamp.copy();
        this.transactionHash = transactionRecord.transactionHash.copy();
        this.immutable = false;
        transactionRecord.immutable = true;
    }

    public TransactionRecord() {
        this.accountID = new AccountID();
        this.fileID = new AccountID();
        this.contractID = new AccountID();
        this.timestamp = new FCTimestamp();
        this.transactionHash = new TransactionHash();
    }

    public TransactionRecord copy() {
        this.throwIfImmutable();
        return new TransactionRecord(this);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        if (this.deleted) {
            throw new IllegalStateException("Trying to serialize a deleted TransactionRecord");
        }
        out.writeNormalisedString(this.status);
        out.writeSerializable((SelfSerializable)this.accountID, false);
        out.writeSerializable((SelfSerializable)this.fileID, false);
        out.writeSerializable((SelfSerializable)this.contractID, false);
        out.writeSerializable((SelfSerializable)this.timestamp, false);
        out.writeSerializable((SelfSerializable)this.transactionHash, false);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.status = in.readNormalisedString(Integer.MAX_VALUE);
        this.accountID = (AccountID)in.readSerializable(false, AccountID::new);
        this.fileID = (AccountID)in.readSerializable(false, AccountID::new);
        this.contractID = (AccountID)in.readSerializable(false, AccountID::new);
        this.timestamp = (FCTimestamp)in.readSerializable(false, FCTimestamp::new);
        this.transactionHash = (TransactionHash)in.readSerializable(false, TransactionHash::new);
    }

    public boolean release() {
        this.deleted = true;
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionRecord)) {
            return false;
        }
        TransactionRecord that = (TransactionRecord)((Object)o);
        return this.status.equals(that.status) && this.accountID.equals(that.accountID) && this.fileID.equals(that.fileID) && this.contractID.equals(that.contractID) && this.timestamp.equals((Object)that.timestamp) && this.transactionHash.equals((Object)that.transactionHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.accountID, this.fileID, this.contractID, this.timestamp, this.transactionHash});
    }

    static TransactionRecord generateRandom(Random random) {
        byte[] data = new byte[50];
        random.nextBytes(data);
        String status = new String(data);
        AccountID accountID = AccountID.generateRandom(random);
        AccountID fileID = AccountID.generateRandom(random);
        AccountID contractID = AccountID.generateRandom(random);
        FCTimestamp timestamp = FCTimestamp.generateRandom(random);
        TransactionHash transactionHash = TransactionHash.generateRandom(random);
        return new TransactionRecord(status, accountID, fileID, contractID, timestamp, transactionHash);
    }

    public long getClassId() {
        return -8435811711067532216L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("status", (Object)this.status.getBytes()).append("accountID", (Object)this.accountID).append("fileID", (Object)this.fileID).append("contractID", (Object)this.contractID).append("timestamp", (Object)this.timestamp).append("transactionHash", (Object)this.transactionHash).append("deleted", (Object)this.deleted).toString();
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

