/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.wires.output.internal;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.internal.ForwardingOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class TransformingOutputWire<IN, OUT>
extends ForwardingOutputWire<IN, OUT> {
    private final List<Consumer<OUT>> forwardingDestinations = new ArrayList<Consumer<OUT>>();
    private final Function<IN, OUT> transform;
    private final Consumer<IN> inputCleanup;
    private final Consumer<OUT> outputCleanup;

    public TransformingOutputWire(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull Function<IN, OUT> transformer, @Nullable Consumer<IN> inputCleanup, @Nullable Consumer<OUT> outputCleanup) {
        super(model, name, uncaughtExceptionHandler);
        this.transform = Objects.requireNonNull(transformer);
        this.inputCleanup = inputCleanup == null ? data -> {} : inputCleanup;
        this.outputCleanup = outputCleanup == null ? data -> {} : outputCleanup;
    }

    @Override
    protected void addForwardingDestination(@NonNull Consumer<OUT> destination) {
        Objects.requireNonNull(destination);
        this.forwardingDestinations.add(destination);
    }

    @Override
    public void forward(@NonNull IN data) {
        for (Consumer<OUT> destination : this.forwardingDestinations) {
            try {
                OUT transformed = this.transform.apply(data);
                if (transformed == null) {
                    return;
                }
                destination.accept(transformed);
            }
            catch (Exception e) {
                this.getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
            }
        }
        this.inputCleanup.accept(data);
    }

    @Override
    public void solderTo(@NonNull InputWire<OUT> inputWire, @NonNull SolderType solderType) {
        this.getModel().registerEdge(this.getName(), inputWire.getTaskSchedulerName(), inputWire.getName(), solderType);
        switch (solderType) {
            case PUT: {
                this.addForwardingDestination(inputWire::put);
                break;
            }
            case INJECT: {
                this.addForwardingDestination(inputWire::inject);
                break;
            }
            case OFFER: {
                this.addForwardingDestination(x -> {
                    if (!inputWire.offer(x)) {
                        this.outputCleanup.accept(x);
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown solder type: " + String.valueOf((Object)solderType));
            }
        }
    }
}

