/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.internal.impl;

import com.swirlds.base.internal.impl.BaseExecutorThreadFactory;
import com.swirlds.base.internal.observe.BaseExecutorObserver;
import com.swirlds.base.internal.observe.BaseTaskDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BaseScheduledExecutorService
implements ScheduledExecutorService {
    public static final int CORE_POOL_SIZE = 1;
    private static final Lock instanceLock = new ReentrantLock();
    private final ScheduledExecutorService innerService;
    private final List<BaseExecutorObserver> observers;

    private BaseScheduledExecutorService() {
        BaseExecutorThreadFactory threadFactory = new BaseExecutorThreadFactory();
        this.innerService = Executors.newScheduledThreadPool(1, threadFactory);
        this.observers = new CopyOnWriteArrayList<BaseExecutorObserver>();
        Thread shutdownHook = new Thread(() -> this.innerService.shutdown());
        shutdownHook.setName("BaseScheduledExecutorService-shutdownHook");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public void addObserver(@NonNull BaseExecutorObserver observer) {
        Objects.requireNonNull(observer, "observer must not be null");
        this.observers.add(observer);
    }

    public void removeObserver(@NonNull BaseExecutorObserver observer) {
        Objects.requireNonNull(observer, "observer must not be null");
        this.observers.add(observer);
    }

    @NonNull
    private Runnable wrapOnSubmit(@NonNull Runnable command) {
        Objects.requireNonNull(command, "command must not be null");
        BaseTaskDefinition taskDefinition = BaseTaskDefinition.of(command);
        this.observers.forEach(observer -> observer.onTaskSubmitted(taskDefinition));
        return () -> {
            long start = System.currentTimeMillis();
            this.observers.forEach(observer -> observer.onTaskStarted(taskDefinition));
            try {
                command.run();
                this.observers.forEach(observer -> observer.onTaskDone(taskDefinition, Duration.ofMillis(System.currentTimeMillis() - start)));
            }
            catch (Throwable t) {
                this.observers.forEach(observer -> observer.onTaskFailed(taskDefinition, Duration.ofMillis(System.currentTimeMillis() - start)));
                throw t;
            }
        };
    }

    @NonNull
    private <V> Callable<V> wrapOnSubmit(@NonNull Callable<V> callable) {
        Objects.requireNonNull(callable, "callable must not be null");
        BaseTaskDefinition taskDefinition = BaseTaskDefinition.of(callable);
        this.observers.forEach(observer -> observer.onTaskSubmitted(taskDefinition));
        return () -> {
            long start = System.currentTimeMillis();
            this.observers.forEach(observer -> observer.onTaskStarted(taskDefinition));
            try {
                Object result = callable.call();
                this.observers.forEach(observer -> observer.onTaskDone(taskDefinition, Duration.ofMillis(System.currentTimeMillis() - start)));
                return result;
            }
            catch (Throwable t) {
                this.observers.forEach(observer -> observer.onTaskFailed(taskDefinition, Duration.ofMillis(System.currentTimeMillis() - start)));
                throw t;
            }
        };
    }

    @Override
    public ScheduledFuture<?> schedule(@NonNull Runnable command, long delay, @NonNull TimeUnit unit) {
        Runnable wrapped = this.wrapOnSubmit(command);
        return this.innerService.schedule(wrapped, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@NonNull Callable<V> callable, long delay, @NonNull TimeUnit unit) {
        Callable<V> wrapped = this.wrapOnSubmit(callable);
        return this.innerService.schedule(wrapped, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(@NonNull Runnable command, long initialDelay, long period, @NonNull TimeUnit unit) {
        Runnable wrapped = this.wrapOnSubmit(command);
        return this.innerService.scheduleAtFixedRate(wrapped, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(@NonNull Runnable command, long initialDelay, long delay, @NonNull TimeUnit unit) {
        Runnable wrapped = this.wrapOnSubmit(command);
        return this.innerService.scheduleWithFixedDelay(wrapped, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        throw new IllegalStateException("This executor is managed by the base modules and should not be shut down");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new IllegalStateException("This executor is managed by the base modules and should not be shut down");
    }

    @Override
    public boolean isShutdown() {
        return this.innerService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.innerService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.innerService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Callable<T> wrapped = this.wrapOnSubmit(task);
        return this.innerService.submit(wrapped);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Runnable wrapped = this.wrapOnSubmit(task);
        return this.innerService.submit(wrapped, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        Runnable wrapped = this.wrapOnSubmit(task);
        return this.innerService.submit(wrapped);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List<Callable> wrapped = tasks.stream().map(this::wrapOnSubmit).toList();
        return this.innerService.invokeAll(wrapped);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<Callable> wrapped = tasks.stream().map(this::wrapOnSubmit).toList();
        return this.innerService.invokeAll(wrapped, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List<Callable> wrapped = tasks.stream().map(this::wrapOnSubmit).toList();
        return this.innerService.invokeAny(wrapped);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List<Callable> wrapped = tasks.stream().map(this::wrapOnSubmit).toList();
        return this.innerService.invokeAny(wrapped, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        Runnable wrapped = this.wrapOnSubmit(command);
        this.innerService.execute(wrapped);
    }

    @NonNull
    public static BaseScheduledExecutorService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static final class InstanceHolder {
        private static final BaseScheduledExecutorService INSTANCE = new BaseScheduledExecutorService();

        private InstanceHolder() {
        }
    }
}

