/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.util;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.test.fixtures.dummy.Key;
import com.swirlds.common.test.fixtures.dummy.Value;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.test.fixtures.map.dummy.FCQValue;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MapMutatorSet {
    private static final Marker FCM_TEST = MarkerManager.getMarker((String)"FCM_TEST");
    private static final Logger logger = LogManager.getLogger(MapMutatorSet.class);
    public static final Random random = new Random();
    private final ValueType valueType;

    public MapMutatorSet(ValueType valueType) {
        this.valueType = valueType;
    }

    public <V extends MerkleNode> void insertIntoMap(int startIndex, int endIndex, Map<Key, V> fcm) {
        switch (this.valueType.ordinal()) {
            case 0: {
                MapMutatorSet.insertKeyValueIntoMap(startIndex, endIndex, fcm);
                break;
            }
            case 1: {
                MapMutatorSet.insertKeyFCQIntoMap(startIndex, endIndex, fcm);
                break;
            }
            default: {
                logger.error(LogMarker.EXCEPTION.getMarker(), () -> "Invalid ValueType");
            }
        }
    }

    public static <V extends FastCopyable> void insertKeyFCQIntoMap(int startIndex, int endIndex, Map<Key, V> fcm) {
        for (int index = startIndex; index < endIndex; ++index) {
            Key key = new Key(new long[]{index, index, index});
            FCQValue<TransactionRecord> value = FCQValue.buildRandomWithIndex(index);
            fcm.put(key, value);
        }
    }

    public static <V extends MerkleNode> void insertKeyValueIntoMap(int startIndex, int endIndex, Map<Key, V> fcm) {
        long startTime = System.nanoTime();
        for (int index = startIndex; index < endIndex; ++index) {
            Key key = new Key(new long[]{index, index, index});
            Value value = new Value((long)index, (long)index, (long)index, true);
            fcm.put(key, value);
        }
        long endTime = System.nanoTime();
        long totalTime = (endTime - startTime) / 1000000L;
        logger.info(FCM_TEST, "Inserting from {} to {} elements into MerkleMap took {} milliseconds", (Object)startIndex, (Object)endIndex, (Object)totalTime);
    }

    public <K, V extends FastCopyable> void modifyMap(Map<K, V> fcm, int percentage, ModifyType modifyType) {
        HashSet<K> toBeModifiedKeys = new HashSet<K>();
        for (Map.Entry<K, V> entry : fcm.entrySet()) {
            if (random.nextInt(100) >= percentage) continue;
            toBeModifiedKeys.add(entry.getKey());
        }
        long startTime = System.nanoTime();
        for (Object key : toBeModifiedKeys) {
            if (modifyType.equals((Object)ModifyType.UPDATE)) {
                Object value = null;
                switch (this.valueType.ordinal()) {
                    case 0: {
                        value = Value.buildRandomValue();
                        break;
                    }
                    case 1: {
                        value = FCQValue.buildRandom();
                    }
                }
                fcm.put(key, (Value)value);
                continue;
            }
            fcm.remove(key);
        }
        long endTime = System.nanoTime();
        long totalTime = (endTime - startTime) / 1000000L;
        logger.info(FCM_TEST, "{} {} elements in MerkleMap (with {} elements) took {} milliseconds", (Object)modifyType, (Object)toBeModifiedKeys.size(), (Object)fcm.size(), (Object)totalTime);
    }

    public <K, V extends FastCopyable> void updateValueInMap(Map<K, V> fcm, int percentage) {
        this.modifyMap(fcm, percentage, ModifyType.UPDATE);
    }

    public <K, V extends FastCopyable> void deleteFromMap(Map<K, V> fcm, int percentage) {
        this.modifyMap(fcm, percentage, ModifyType.DELETE);
    }

    public static enum ValueType {
        SIMPLE,
        FCQ,
        FCM;

    }

    public static enum ModifyType {
        UPDATE("Update"),
        DELETE("Delete");

        private final String name;

        private ModifyType(String name) {
            this.name = name;
        }
    }
}

