/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.config;

import com.swirlds.config.api.ConfigData;
import java.time.Duration;

@ConfigData(value="virtualMap")
public record VirtualMapConfig(double percentHashThreads, int numHashThreads, int virtualHasherChunkHeight, String reconnectMode, int reconnectFlushInterval, double percentCleanerThreads, int numCleanerThreads, int flushInterval, long copyFlushCandidateThreshold, long familyThrottleThreshold, int preferredFlushQueueSize, Duration flushThrottleStepSize, Duration maximumFlushThrottlePeriod, boolean validateMigrationEnabled) {
    private static final double UNIT_FRACTION_PERCENT = 100.0;

    public int getNumHashThreads() {
        int threads = this.numHashThreads() == -1 ? (int)((double)Runtime.getRuntime().availableProcessors() * (this.percentHashThreads() / 100.0)) : this.numHashThreads();
        return Math.max(1, threads);
    }

    public int getNumCleanerThreads() {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int threads = this.numCleanerThreads() == -1 ? (int)((double)numProcessors * (this.percentCleanerThreads() / 100.0)) : this.numCleanerThreads();
        return Math.max(1, threads);
    }
}

