/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.interrupt;

import com.swirlds.base.function.CheckedConsumer;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;
import org.hiero.base.concurrent.interrupt.InterruptableSupplier;

public final class Uninterruptable {
    private static final Logger logger = LogManager.getLogger(Uninterruptable.class);

    private Uninterruptable() {
    }

    public static void retryIfInterrupted(@NonNull InterruptableRunnable action) {
        Objects.requireNonNull(action, "action");
        Uninterruptable.retryIfInterrupted(() -> {
            action.run();
            return null;
        });
    }

    @Nullable
    public static <T> T retryIfInterrupted(@NonNull InterruptableSupplier<T> action) {
        Objects.requireNonNull(action, "action");
        boolean finished = false;
        boolean interrupted = false;
        T value = null;
        while (!finished) {
            try {
                value = action.get();
                finished = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return value;
    }

    public static void abortIfInterrupted(@NonNull InterruptableRunnable action) {
        Objects.requireNonNull(action, "action");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndLogIfInterrupted(@NonNull InterruptableRunnable action, @NonNull String errorMessage) {
        Objects.requireNonNull(action, "action must not be null");
        Objects.requireNonNull(errorMessage, "errorMessage must not be null");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static <T> void abortAndLogIfInterrupted(@NonNull CheckedConsumer<T, InterruptedException> consumer, @Nullable T object, @NonNull String errorMessage) {
        Objects.requireNonNull(consumer, "consumer must not be null");
        Objects.requireNonNull(errorMessage, "errorMessage must not be null");
        try {
            consumer.accept(object);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndThrowIfInterrupted(@NonNull InterruptableRunnable action, @NonNull String errorMessage) {
        Objects.requireNonNull(action, "action must not be null");
        Objects.requireNonNull(errorMessage, "errorMessage must not be null");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage, (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage, e);
        }
    }

    public static <T> void abortAndThrowIfInterrupted(@NonNull CheckedConsumer<T, InterruptedException> consumer, @Nullable T object, @NonNull String errorMessage) {
        Objects.requireNonNull(consumer, "consumer must not be null");
        Objects.requireNonNull(errorMessage, "errorMessage must not be null");
        try {
            consumer.accept(object);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage, (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage, e);
        }
    }

    public static void tryToSleep(@NonNull Duration duration) {
        Objects.requireNonNull(duration, "duration must not be null");
        Uninterruptable.abortIfInterrupted(() -> TimeUnit.MILLISECONDS.sleep(duration.toMillis()));
    }
}

