/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.demo.migration.AccountID;
import com.swirlds.demo.migration.InternalValue;
import com.swirlds.demo.migration.MapKey;
import com.swirlds.demo.migration.TransactionRecord;
import com.swirlds.fcqueue.FCQueue;
import java.util.Objects;
import java.util.Random;

public class MapValue
extends PartialNaryMerkleInternal
implements Keyed<AccountID>,
MerkleInternal {
    private static final long CLASS_ID = -7348593486458164548L;

    public MapValue() {
        this.setMapKey(new MapKey());
        this.setRecords((FCQueue<TransactionRecord>)new FCQueue());
        this.setInternalValue(new InternalValue());
    }

    private MapValue(AccountID key, long balance, long expirationTime, long autoRenewPeriod, long senderThreshold, long receiverThreshold, String memo, boolean isSmartContract, boolean receiverSigRequired, FCQueue<TransactionRecord> records) {
        this.setMapKey(new MapKey(key));
        this.setInternalValue(new InternalValue(balance, expirationTime, autoRenewPeriod, senderThreshold, receiverThreshold, memo, isSmartContract, receiverSigRequired));
        this.setRecords(records);
    }

    public int getNumberOfChildren() {
        return 3;
    }

    public int getMinimumChildCount() {
        return 3;
    }

    public int getMaximumChildCount() {
        return 3;
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        switch (index) {
            case 0: {
                return childClassId == 3874693200313208788L;
            }
            case 1: {
                return childClassId == 139236190103L;
            }
            case 2: {
                return childClassId == -6094795881748116928L;
            }
        }
        throw new IllegalChildIndexException(this.getMinimumChildCount(), this.getMaximumChildCount(), index);
    }

    private MapKey getMapKey() {
        return (MapKey)this.getChild(0);
    }

    private void setMapKey(MapKey mapKey) {
        this.setChild(0, (MerkleNode)mapKey);
    }

    private InternalValue getInternalValue() {
        return (InternalValue)this.getChild(2);
    }

    private void setInternalValue(InternalValue internalValue) {
        this.setChild(2, (MerkleNode)internalValue);
    }

    private FCQueue<TransactionRecord> getRecords() {
        return (FCQueue)this.getChild(1);
    }

    private void setRecords(FCQueue<TransactionRecord> records) {
        this.setChild(1, (MerkleNode)records);
    }

    private MapValue(MapValue mapValue) {
        if (mapValue.getMapKey() != null) {
            this.setMapKey(mapValue.getMapKey().copy());
        }
        if (mapValue.getInternalValue() != null) {
            this.setInternalValue(mapValue.getInternalValue().copy());
        }
        if (mapValue.getRecords() != null) {
            this.setRecords((FCQueue<TransactionRecord>)mapValue.getRecords().copy());
        }
    }

    public MapValue copy() {
        this.throwIfImmutable();
        return new MapValue(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        MapValue that = (MapValue)((Object)other);
        return Objects.equals((Object)this.getMapKey(), (Object)that.getMapKey()) && Objects.equals((Object)this.getInternalValue(), (Object)that.getInternalValue()) && Objects.equals(this.getRecords(), that.getRecords());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMapKey(), this.getInternalValue(), this.getRecords()});
    }

    static MapValue generateRandom(Random random, AccountID key) {
        long balance = random.nextLong();
        long expirationtime = random.nextLong();
        long autoRenewPeriod = random.nextLong();
        long senderThreshold = random.nextLong();
        long receiverThreshold = random.nextLong();
        boolean isSmartContract = random.nextBoolean();
        boolean receiverSigRequired = random.nextBoolean();
        byte[] string = new byte[50];
        random.nextBytes(string);
        String memo = new String(string);
        byte[] internalData = new byte[100];
        random.nextBytes(internalData);
        FCQueue<TransactionRecord> records = MapValue.generateRandomFCQ(random);
        return new MapValue(key, balance, expirationtime, autoRenewPeriod, senderThreshold, receiverThreshold, memo, isSmartContract, receiverSigRequired, records);
    }

    public static FCQueue<TransactionRecord> generateRandomFCQ(Random random) {
        FCQueue records = new FCQueue();
        for (int index = 0; index < 10; ++index) {
            records.add((FastCopyable)TransactionRecord.generateRandom(random));
        }
        return records;
    }

    public AccountID getKey() {
        return ((MapKey)this.getChild(0)).getAccountId();
    }

    public void setKey(AccountID accountID) {
        if (this.getChild(0) == null) {
            this.setChild(0, (MerkleNode)new MapKey(accountID));
        } else {
            this.getMapKey().setAccountId(accountID);
        }
    }

    public long getClassId() {
        return -7348593486458164548L;
    }

    public int getVersion() {
        return 3;
    }

    public int getMinimumSupportedVersion() {
        return 3;
    }

    private static class ChildIndices {
        public static final int MAP_KEY = 0;
        public static final int RECORDS = 1;
        public static final int INTERNAL_VALUE = 2;
        public static final int CHILD_COUNT = 3;

        private ChildIndices() {
        }
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 2;
        public static final int NO_BLOBS = 3;

        private ClassVersion() {
        }
    }
}

