/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import com.swirlds.fchashmap.internal.KeyIndexPair;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class FCOneToManyRelationIterator<K, V>
implements Iterator<V> {
    private final Map<KeyIndexPair<K>, V> associationMap;
    private final K key;
    private final int endIndex;
    private int nextIndex;

    public FCOneToManyRelationIterator(Map<KeyIndexPair<K>, V> associationMap, K key, int startIndex, int endIndex) {
        this.associationMap = associationMap;
        this.key = key;
        this.endIndex = endIndex;
        this.nextIndex = startIndex;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.endIndex;
    }

    @Override
    public V next() {
        int index;
        V next;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if ((next = this.associationMap.get(new KeyIndexPair<K>(this.key, index = this.nextIndex++))) == null) {
            throw new IllegalStateException("end index exceeds number of available values");
        }
        return next;
    }
}

