/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.counters;

import com.swirlds.component.framework.counters.EmptyBlocker;
import com.swirlds.component.framework.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;

public class StandardObjectCounter
extends ObjectCounter {
    private final AtomicLong count = new AtomicLong(0L);
    private final ForkJoinPool.ManagedBlocker waitUntilEmptyBlocker;

    public StandardObjectCounter(@NonNull Duration sleepDuration) {
        long sleepNanos = sleepDuration.toNanos();
        this.waitUntilEmptyBlocker = new EmptyBlocker(this.count, sleepNanos);
    }

    @Override
    public void onRamp(long delta) {
        this.count.addAndGet(delta);
    }

    @Override
    public boolean attemptOnRamp(long delta) {
        this.count.getAndAdd(delta);
        return true;
    }

    @Override
    public void forceOnRamp(long delta) {
        this.count.getAndAdd(delta);
    }

    @Override
    public void offRamp(long delta) {
        this.count.addAndGet(-delta);
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public void waitUntilEmpty() {
        if (this.count.get() == 0L) {
            return;
        }
        try {
            ForkJoinPool.managedBlock(this.waitUntilEmptyBlocker);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while blocking on an waitUntilEmpty()");
        }
    }
}

