/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.internal.network.codec;

import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NetworkJsonCodec
implements JsonCodec<Network> {
    @NonNull
    public Network parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            List temp_node_metadata = Collections.emptyList();
            Bytes temp_ledger_id = Bytes.EMPTY;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nodeMetadata": {
                        temp_node_metadata = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), NodeMetadata.JSON, (int)(maxDepth - 1));
                        continue block10;
                    }
                    case "ledgerId": {
                        temp_ledger_id = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Network(temp_node_metadata, temp_ledger_id);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Network data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (!data.nodeMetadata().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"nodeMetadata", NodeMetadata.JSON, data.nodeMetadata()));
        }
        if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

