/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.hiero.base.crypto.CryptographyException;

public class CryptoUtils {
    private CryptoUtils() {
    }

    public static boolean checkCertificate(@Nullable Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        if (certificate.getPublicKey() == null) {
            return false;
        }
        try {
            if (certificate.getEncoded().length == 0) {
                return false;
            }
        }
        catch (CertificateEncodingException e) {
            return false;
        }
        return true;
    }

    @NonNull
    public static X509Certificate decodeCertificate(@NonNull byte[] encoded) {
        X509Certificate x509Certificate;
        ByteArrayInputStream in = new ByteArrayInputStream(encoded);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)factory.generateCertificate(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                throw new CryptographyException(e);
            }
        }
        ((InputStream)in).close();
        return x509Certificate;
    }
}

