/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.sync.protocol;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.SyncException;
import com.swirlds.platform.gossip.permits.SyncPermitProvider;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphSynchronizer;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.gossip.sync.protocol.SyncStatusChecker;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.hiero.base.CompareTo;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class SyncPeerProtocol
implements PeerProtocol {
    private final NodeId peerId;
    private final ShadowgraphSynchronizer synchronizer;
    private final FallenBehindManager fallenBehindManager;
    private final SyncMetrics syncMetrics;
    private final SyncPermitProvider permitProvider;
    private final IntakeEventCounter intakeEventCounter;
    private final BooleanSupplier gossipHalted;
    private final boolean keepSendingEventsWhenUnhealthy;
    private Instant lastSyncTime = Instant.MIN;
    private final Duration sleepAfterSync;
    private final PlatformContext platformContext;
    private final Supplier<PlatformStatus> platformStatusSupplier;

    public SyncPeerProtocol(@NonNull PlatformContext platformContext, @NonNull NodeId peerId, @NonNull ShadowgraphSynchronizer synchronizer, @NonNull FallenBehindManager fallenBehindManager, @NonNull SyncPermitProvider permitProvider, @NonNull IntakeEventCounter intakeEventCounter, @NonNull BooleanSupplier gossipHalted, @NonNull Duration sleepAfterSync, @NonNull SyncMetrics syncMetrics, @NonNull Supplier<PlatformStatus> platformStatusSupplier) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.peerId = Objects.requireNonNull(peerId);
        this.synchronizer = Objects.requireNonNull(synchronizer);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.permitProvider = Objects.requireNonNull(permitProvider);
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.gossipHalted = Objects.requireNonNull(gossipHalted);
        this.sleepAfterSync = Objects.requireNonNull(sleepAfterSync);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.keepSendingEventsWhenUnhealthy = ((SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class)).keepSendingEventsWhenUnhealthy();
    }

    private boolean syncCooldownComplete() {
        Duration elapsed = Duration.between(this.lastSyncTime, this.platformContext.getTime().now());
        return CompareTo.isGreaterThanOrEqualTo((Comparable)elapsed, (Object)this.sleepAfterSync);
    }

    private boolean shouldSync() {
        if (!SyncStatusChecker.doesStatusPermitSync(this.platformStatusSupplier.get())) {
            this.syncMetrics.doNotSyncPlatformStatus();
            return false;
        }
        if (!this.syncCooldownComplete()) {
            this.syncMetrics.doNotSyncCooldown();
            return false;
        }
        if (this.gossipHalted.getAsBoolean()) {
            this.syncMetrics.doNotSyncHalted();
            return false;
        }
        if (this.fallenBehindManager.hasFallenBehind()) {
            this.syncMetrics.doNotSyncFallenBehind();
            return false;
        }
        if (this.intakeEventCounter.hasUnprocessedEvents(this.peerId)) {
            this.syncMetrics.doNotSyncIntakeCounter();
            return false;
        }
        if (!this.permitProvider.acquire()) {
            this.syncMetrics.doNotSyncNoPermits();
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldInitiate() {
        this.syncMetrics.opportunityToInitiateSync();
        boolean shouldSync = this.shouldSync();
        if (shouldSync) {
            this.syncMetrics.outgoingSyncRequestSent();
        }
        return shouldSync;
    }

    @Override
    public boolean shouldAccept() {
        this.syncMetrics.incomingSyncRequestReceived();
        boolean shouldSync = this.shouldSync();
        if (shouldSync) {
            this.syncMetrics.acceptedSyncRequest();
        }
        return shouldSync;
    }

    private void returnPermit() {
        this.permitProvider.release();
    }

    @Override
    public void initiateFailed() {
        this.returnPermit();
    }

    @Override
    public void acceptFailed() {
        this.returnPermit();
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return true;
    }

    @Override
    public void runProtocol(@NonNull Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        try {
            this.synchronizer.synchronize(this.platformContext, connection, !this.permitProvider.isHealthy() && this.keepSendingEventsWhenUnhealthy);
        }
        catch (ParallelExecutionException | SyncException e) {
            if (Utilities.isRootCauseSuppliedType(e, IOException.class)) {
                throw new IOException(e);
            }
            throw new NetworkProtocolException(e);
        }
        finally {
            this.returnPermit();
            this.lastSyncTime = this.platformContext.getTime().now();
        }
    }
}

