/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.platform.gui.model.InfoApp;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class StateHierarchy {
    List<InfoApp> apps = new ArrayList<InfoApp>();

    public StateHierarchy(String fromAppName) {
        Path appsDirPath = FileUtils.getAbsolutePath().resolve("data").resolve("apps");
        List appFiles = (List)FileUtils.rethrowIO(() -> Files.list(appsDirPath).filter(path -> path.toString().endsWith(".jar")).toList());
        ArrayList<String> names = new ArrayList<String>();
        if (fromAppName != null) {
            names.add(fromAppName);
            List toDelete = (List)FileUtils.rethrowIO(() -> Files.list(appsDirPath).filter(path -> path.getFileName().toString().equals(fromAppName)).toList());
            if (toDelete != null) {
                for (Path file : toDelete) {
                    FileUtils.rethrowIO(() -> Files.deleteIfExists(file));
                }
            }
        }
        if (appFiles != null) {
            for (Path app : appFiles) {
                names.add(StateHierarchy.getMainClass(app.toAbsolutePath().toString()));
            }
        }
        names.sort(null);
        for (String name : names) {
            name = name.substring(0, name.length() - 4);
            this.apps.add(new InfoApp(name));
        }
    }

    private static String getMainClass(String appJarPath) {
        String string;
        JarFile jarFile = new JarFile(appJarPath);
        try {
            String mainClassname;
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            string = mainClassname = attributes.getValue("Main-Class");
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                CommonUtils.tellUserConsolePopup((String)"ERROR", (String)("ERROR: Couldn't load app " + appJarPath));
                return null;
            }
        }
        jarFile.close();
        return string;
    }

    public InfoApp getInfoApp(String name) {
        for (InfoApp app : this.apps) {
            if (!name.equals(app.getName())) continue;
            return app;
        }
        return null;
    }
}

