/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.stats;

import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.stats.AverageTimeStat;
import com.swirlds.platform.stats.cycle.CycleDefinition;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class CycleTimingStat {
    private final AverageTimeStat totalCycleTimeStat;
    private final List<AverageTimeStat> timePointStats;
    private final int numIntervals;
    private final long[] t;

    public CycleTimingStat(Metrics metrics, ChronoUnit unit, CycleDefinition definition) {
        this.numIntervals = definition.getNumIntervals();
        this.t = new long[this.numIntervals + 1];
        this.timePointStats = new ArrayList<AverageTimeStat>(this.numIntervals);
        for (int i = 0; i < this.numIntervals; ++i) {
            this.timePointStats.add(new AverageTimeStat(metrics, unit, definition.getCategory(), definition.getName() + "_" + definition.getIntervalName(i), definition.getIntervalDescription(i), 0.1));
        }
        this.totalCycleTimeStat = new AverageTimeStat(metrics, unit, definition.getCategory(), definition.getName() + "_total", "average total time spend in the " + definition.getName() + " cycle.", 0.1);
    }

    public void setTimePoint(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("Time point must be greater than 0. Use startCycle() to mark the beginning of the cycle.");
        }
        if (i >= this.numIntervals) {
            throw new IllegalArgumentException(String.format("Time point must be less than %s. Use stopCycle() to mark the end of the cycle.", this.numIntervals - 1));
        }
        this.t[i] = CycleTimingStat.now();
    }

    public void startCycle() {
        this.t[0] = CycleTimingStat.now();
    }

    public void stopCycle() {
        this.t[this.numIntervals] = CycleTimingStat.now();
        for (int i = 0; i < this.t.length - 1; ++i) {
            this.timePointStats.get(i).update(this.t[i], this.t[i + 1]);
        }
        this.totalCycleTimeStat.update(this.t[0], this.t[this.t.length - 1]);
    }

    private static long now() {
        return System.nanoTime();
    }
}

