/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.address;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.address.AddressBookInitializer;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.util.BootstrapUtils;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.ParseException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;

public class AddressBookUtils {
    public static final String ADDRESS_KEYWORD = "address";
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$");

    private AddressBookUtils() {
    }

    @NonNull
    public static String addressBookConfigText(@NonNull AddressBook addressBook) {
        Objects.requireNonNull(addressBook, "The addressBook must not be null.");
        TextTable table = new TextTable().setBordersEnabled(false);
        for (Address address : addressBook) {
            String memo = address.getMemo();
            boolean hasMemo = !memo.trim().isEmpty();
            boolean hasInternalIpv4 = address.getHostnameInternal() != null;
            boolean hasExternalIpv4 = address.getHostnameExternal() != null;
            table.addRow(new Object[]{"address,", String.valueOf(address.getNodeId()) + ",", address.getNickname() + ",", address.getSelfName() + ",", address.getWeight() + ",", (hasInternalIpv4 ? address.getHostnameInternal() : "") + ",", address.getPortInternal() + ",", (hasExternalIpv4 ? address.getHostnameExternal() : "") + ",", address.getPortExternal() + (hasMemo ? "," : ""), memo});
        }
        return table.render();
    }

    @NonNull
    public static AddressBook parseAddressBookText(@NonNull String addressBookText) throws ParseException {
        Objects.requireNonNull(addressBookText, "The addressBookText must not be null.");
        AddressBook addressBook = new AddressBook();
        for (String line : addressBookText.split("\\r?\\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#") || trimmedLine.startsWith("swirld") || trimmedLine.startsWith("app")) continue;
            if (trimmedLine.startsWith(ADDRESS_KEYWORD)) {
                Address address = AddressBookUtils.parseAddressText(trimmedLine);
                if (address == null) continue;
                addressBook.add(address);
                continue;
            }
            if (trimmedLine.startsWith("nextNodeId")) continue;
            throw new ParseException("The line [%s] does not start with `%s`.".formatted(line.substring(0, Math.min(line.length(), 30)), ADDRESS_KEYWORD), 0);
        }
        return addressBook;
    }

    @Nullable
    public static Address parseAddressText(@NonNull String addressText) throws ParseException {
        int externalPort;
        int internalPort;
        long weight;
        NodeId nodeId;
        Objects.requireNonNull(addressText, "The addressText must not be null.");
        String[] textAndComment = addressText.split("#");
        if (textAndComment.length == 0 || textAndComment[0] == null || textAndComment[0].trim().isEmpty()) {
            return null;
        }
        String[] parts = addressText.split(",");
        if (parts.length < 9 || parts.length > 10) {
            throw new ParseException("Incorrect number of parts in the address line to parse correctly.", parts.length);
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (!parts[0].equals(ADDRESS_KEYWORD)) {
            throw new ParseException("The address line must start with 'address' and not '" + parts[0] + "'", 0);
        }
        try {
            nodeId = NodeId.of((long)Long.parseLong(parts[1]));
        }
        catch (Exception e) {
            throw new ParseException("Cannot parse node id from '" + parts[1] + "'", 1);
        }
        String nickname = parts[2];
        String selfname = parts[3];
        try {
            weight = Long.parseLong(parts[4]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse value of weight from '" + parts[4] + "'", 4);
        }
        String internalHostname = parts[5];
        try {
            internalPort = Integer.parseInt(parts[6]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[6] + "'", 6);
        }
        String externalHostname = parts[7];
        try {
            externalPort = Integer.parseInt(parts[8]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[8] + "'", 8);
        }
        String memoToUse = parts.length == 10 ? parts[9] : "";
        return new Address(nodeId, nickname, selfname, weight, internalHostname, internalPort, externalHostname, externalPort, null, null, memoToUse);
    }

    public static ServiceEndpoint endpointFor(@NonNull String host, int port) {
        ServiceEndpoint.Builder builder = ServiceEndpoint.newBuilder().port(port);
        if (IPV4_ADDRESS_PATTERN.matcher(host).matches()) {
            String[] octets = host.split("[.]");
            builder.ipAddressV4(Bytes.wrap((byte[])new byte[]{(byte)Integer.parseInt(octets[0]), (byte)Integer.parseInt(octets[1]), (byte)Integer.parseInt(octets[2]), (byte)Integer.parseInt(octets[3])}));
        } else {
            builder.domainName(host);
        }
        return builder.build();
    }

    public static void initializeAddressBook(@NonNull NodeId selfId, @NonNull SemanticVersion version, @NonNull ReservedSignedState initialState, @NonNull AddressBook bootstrapAddressBook, @NonNull PlatformContext platformContext, @NonNull ConsensusStateEventHandler<?> consensusStateEventHandler, @NonNull PlatformStateFacade platformStateFacade) {
        long round;
        AddressBook addressBook;
        boolean softwareUpgrade = BootstrapUtils.detectSoftwareUpgrade(version, initialState.get(), platformStateFacade);
        AddressBookInitializer addressBookInitializer = new AddressBookInitializer(selfId, softwareUpgrade, initialState.get(), bootstrapAddressBook.copy(), platformContext, consensusStateEventHandler, platformStateFacade);
        MerkleNodeState state = initialState.get().getState();
        if (addressBookInitializer.hasAddressBookChanged()) {
            long round2;
            Roster previousRoster;
            if (addressBookInitializer.getPreviousAddressBook() != null && !(previousRoster = RosterRetriever.buildRoster((AddressBook)addressBookInitializer.getPreviousAddressBook())).equals((Object)RosterRetriever.retrieveActive((State)state, (long)(round2 = platformStateFacade.roundOf(state)))) && !previousRoster.equals((Object)RosterRetriever.retrievePreviousRoster((State)state))) {
                throw new IllegalStateException("The previousRoster in the AddressBookInitializer doesn't match either the active or previous roster in state. AddressBookInitializer previousRoster = " + RosterUtils.toString((Roster)previousRoster) + ", state currentRoster = " + RosterUtils.toString((Roster)RosterRetriever.retrieveActive((State)state, (long)round2)) + ", state previousRoster = " + RosterUtils.toString((Roster)RosterRetriever.retrievePreviousRoster((State)state)));
            }
            if (initialState.get().getRound() > 0L) {
                RosterUtils.setActiveRoster((State)state, (Roster)RosterRetriever.buildRoster((AddressBook)addressBookInitializer.getCurrentAddressBook()), (long)(platformStateFacade.roundOf(state) + 1L));
            }
        }
        if ((addressBook = RosterUtils.buildAddressBook((Roster)RosterRetriever.retrieveActive((State)state, (long)(round = platformStateFacade.roundOf(state))))) == null) {
            throw new IllegalStateException("The current address book of the initial state is null.");
        }
    }
}

