/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.dummy;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class BlockingInputStream
extends InputStream {
    private final AtomicBoolean locked = new AtomicBoolean(false);
    private final InputStream in;

    public BlockingInputStream(InputStream in) {
        this.in = in;
    }

    public void lock() {
        this.locked.set(true);
    }

    public void unlock() {
        this.locked.set(false);
    }

    @Override
    public int read() throws IOException {
        while (this.locked.get()) {
            Thread.onSpinWait();
        }
        return this.in.read();
    }
}

