/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.state.Startable;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.platform.system.Platform;
import java.util.Random;
import org.hiero.base.utility.ByteUtils;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public class TransactionGenerator
implements Startable {
    private final Random random;
    private final TransactionPoolNexus transactionPool;
    private final StoppableThread thread;

    public TransactionGenerator(Random random, Platform platform, TransactionPoolNexus transactionPool, int networkWideTransactionsPerSecond) {
        this.random = random;
        this.transactionPool = transactionPool;
        int tps = networkWideTransactionsPerSecond / platform.getRoster().rosterEntries().size();
        this.thread = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("iss-testing-tool")).setThreadName("transaction-generator")).setMaximumRate((double)tps)).setWork(this::generateTransaction).build();
    }

    public void start() {
        this.thread.start();
    }

    private void generateTransaction() {
        this.transactionPool.submitApplicationTransaction(Bytes.wrap((byte[])ByteUtils.intToByteArray((int)this.random.nextInt())));
    }
}

