/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.standard;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.TimerTask;

public class HeartbeatTask
extends TimerTask {
    private final Time time;
    private final Duration period;
    private final StandardOutputWire<Instant> outputWire;

    public HeartbeatTask(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull Time time, @NonNull Duration period, @NonNull Thread.UncaughtExceptionHandler exceptionHandler) {
        this.time = Objects.requireNonNull(time);
        this.period = Objects.requireNonNull(period);
        Objects.requireNonNull(name);
        this.outputWire = new StandardOutputWire(model, name, exceptionHandler);
    }

    @NonNull
    public Duration getPeriod() {
        return this.period;
    }

    @NonNull
    public OutputWire<Instant> getOutputWire() {
        return this.outputWire;
    }

    @Override
    public void run() {
        this.outputWire.forward(this.time.now());
    }
}

