/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

public interface JsonCodec<T>
extends Codec<T> {
    @Override
    @NonNull
    default public T parse(@NonNull ReadableSequentialData input, boolean strictMode, boolean parseUnknownFields, int maxDepth) throws ParseException {
        try {
            return this.parse(JsonTools.parseJson(input), strictMode, maxDepth);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    @NonNull
    public T parse(@Nullable JSONParser.ObjContext var1, boolean var2, int var3) throws ParseException;

    @Override
    default public void write(@NonNull T item, @NonNull WritableSequentialData output) throws IOException {
        output.writeUTF8(this.toJSON(item));
    }

    default public String toJSON(@NonNull T item) {
        return this.toJSON(item, "", false);
    }

    public String toJSON(@NonNull T var1, String var2, boolean var3);

    @Override
    default public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long startPosition = input.position();
        this.parse(input);
        return (int)(input.position() - startPosition);
    }

    @Override
    default public int measureRecord(T item) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        WritableStreamingData out = new WritableStreamingData(bout);
        try {
            this.write(item, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bout.size();
    }

    @Override
    default public boolean fastEquals(@NonNull T item, @NonNull ReadableSequentialData input) throws ParseException {
        return Objects.equals(item, this.parse(input));
    }

    @Override
    default public T getDefaultInstance() {
        return null;
    }
}

