/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.state.token.schema.StakingNodeInfoSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StakingNodeInfoJsonCodec
implements JsonCodec<StakingNodeInfo> {
    @NonNull
    public StakingNodeInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_node_number = 0L;
            long temp_min_stake = 0L;
            long temp_max_stake = 0L;
            long temp_stake_to_reward = 0L;
            long temp_stake_to_not_reward = 0L;
            long temp_stake_reward_start = 0L;
            long temp_unclaimed_stake_reward_start = 0L;
            long temp_stake = 0L;
            List<Long> temp_reward_sum_history = Collections.emptyList();
            int temp_weight = 0;
            long temp_pending_rewards = 0L;
            boolean temp_deleted = false;
            block30: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "nodeNumber": {
                        temp_node_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "minStake": {
                        temp_min_stake = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "maxStake": {
                        temp_max_stake = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "stakeToReward": {
                        temp_stake_to_reward = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "stakeToNotReward": {
                        temp_stake_to_not_reward = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "stakeRewardStart": {
                        temp_stake_reward_start = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "unclaimedStakeRewardStart": {
                        temp_unclaimed_stake_reward_start = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "stake": {
                        temp_stake = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "rewardSumHistory": {
                        temp_reward_sum_history = kvPair.value().arr().value().stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                        continue block30;
                    }
                    case "weight": {
                        temp_weight = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "pendingRewards": {
                        temp_pending_rewards = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                    case "deleted": {
                        temp_deleted = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block30;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new StakingNodeInfo(temp_node_number, temp_min_stake, temp_max_stake, temp_stake_to_reward, temp_stake_to_not_reward, temp_stake_reward_start, temp_unclaimed_stake_reward_start, temp_stake, temp_reward_sum_history, temp_weight, temp_pending_rewards, temp_deleted);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull StakingNodeInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.nodeNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"nodeNumber", (long)data.nodeNumber()));
        }
        if (data.minStake() != 0L) {
            fieldLines.add(JsonTools.field((String)"minStake", (long)data.minStake()));
        }
        if (data.maxStake() != 0L) {
            fieldLines.add(JsonTools.field((String)"maxStake", (long)data.maxStake()));
        }
        if (data.stakeToReward() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakeToReward", (long)data.stakeToReward()));
        }
        if (data.stakeToNotReward() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakeToNotReward", (long)data.stakeToNotReward()));
        }
        if (data.stakeRewardStart() != 0L) {
            fieldLines.add(JsonTools.field((String)"stakeRewardStart", (long)data.stakeRewardStart()));
        }
        if (data.unclaimedStakeRewardStart() != 0L) {
            fieldLines.add(JsonTools.field((String)"unclaimedStakeRewardStart", (long)data.unclaimedStakeRewardStart()));
        }
        if (data.stake() != 0L) {
            fieldLines.add(JsonTools.field((String)"stake", (long)data.stake()));
        }
        if (!data.rewardSumHistory().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"rewardSumHistory", (FieldDefinition)StakingNodeInfoSchema.REWARD_SUM_HISTORY, data.rewardSumHistory()));
        }
        if (data.weight() != 0) {
            fieldLines.add(JsonTools.field((String)"weight", (int)data.weight()));
        }
        if (data.pendingRewards() != 0L) {
            fieldLines.add(JsonTools.field((String)"pendingRewards", (long)data.pendingRewards()));
        }
        if (data.deleted()) {
            fieldLines.add(JsonTools.field((String)"deleted", (boolean)data.deleted()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

