/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.block.api.BlockContentsProofRequest;
import org.hiero.block.api.BlockContentsProofResponse;
import org.hiero.block.api.StateProofRequest;
import org.hiero.block.api.StateProofResponse;

public interface ProofServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "ProofService";
    public static final String FULL_NAME = "org.hiero.block.api.ProofService";

    @NonNull
    public BlockContentsProofResponse getBlockContentsProof(@NonNull BlockContentsProofRequest var1);

    @NonNull
    public StateProofResponse getStateProof(@NonNull StateProofRequest var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(ProofServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        ProofServiceMethod m = (ProofServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> ProofServiceInterface.parseBlockContentsProofRequest(bytes, options)).method(this::getBlockContentsProof).mapResponse(reply -> ProofServiceInterface.serializeBlockContentsProofResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> ProofServiceInterface.parseStateProofRequest(bytes, options)).method(this::getStateProof).mapResponse(reply -> ProofServiceInterface.serializeStateProofResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<BlockContentsProofRequest> getBlockContentsProofRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return BlockContentsProofRequest.JSON;
        }
        return BlockContentsProofRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<BlockContentsProofResponse> getBlockContentsProofResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return BlockContentsProofResponse.JSON;
        }
        return BlockContentsProofResponse.PROTOBUF;
    }

    @NonNull
    private static Codec<StateProofRequest> getStateProofRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return StateProofRequest.JSON;
        }
        return StateProofRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<StateProofResponse> getStateProofResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return StateProofResponse.JSON;
        }
        return StateProofResponse.PROTOBUF;
    }

    @NonNull
    private static BlockContentsProofRequest parseBlockContentsProofRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (BlockContentsProofRequest)ProofServiceInterface.getBlockContentsProofRequestCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static StateProofRequest parseStateProofRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (StateProofRequest)ProofServiceInterface.getStateProofRequestCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeBlockContentsProofResponse(@NonNull BlockContentsProofResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return ProofServiceInterface.getBlockContentsProofResponseCodec(options).toBytes((Object)reply);
    }

    @NonNull
    private static Bytes serializeStateProofResponse(@NonNull StateProofResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return ProofServiceInterface.getStateProofResponseCodec(options).toBytes((Object)reply);
    }

    public static enum ProofServiceMethod implements ServiceInterface.Method
    {
        getBlockContentsProof,
        getStateProof;

    }

    public static class ProofServiceClient
    implements ProofServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public ProofServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        @Override
        @NonNull
        public BlockContentsProofResponse getBlockContentsProof(@NonNull BlockContentsProofRequest request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<BlockContentsProofResponse> pipeline = new Pipeline<BlockContentsProofResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(BlockContentsProofResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getBlockContentsProof is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.ProofService/getBlockContentsProof", ProofServiceInterface.getBlockContentsProofRequestCodec(this.requestOptions), ProofServiceInterface.getBlockContentsProofResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (BlockContentsProofResponse)replyRef.get();
            }
            throw new RuntimeException("Call to getBlockContentsProof completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public StateProofResponse getStateProof(@NonNull StateProofRequest request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<StateProofResponse> pipeline = new Pipeline<StateProofResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(StateProofResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getStateProof is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.ProofService/getStateProof", ProofServiceInterface.getStateProofRequestCodec(this.requestOptions), ProofServiceInterface.getStateProofResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (StateProofResponse)replyRef.get();
            }
            throw new RuntimeException("Call to getStateProof completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

