/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.benchmark;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.test.fixtures.benchmark.BenchmarkMetadata;
import com.swirlds.common.test.fixtures.benchmark.BenchmarkOperation;
import com.swirlds.common.test.fixtures.benchmark.BenchmarkStatistic;
import com.swirlds.common.test.fixtures.benchmark.ImmutableStateManager;
import com.swirlds.common.test.fixtures.benchmark.MutableStateManager;
import com.swirlds.common.test.fixtures.benchmark.StateManager;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.common.utility.AutoCloseableWrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Benchmark<S extends MerkleNode, M extends BenchmarkMetadata> {
    private static final Random random = new Random();
    private static final String copyStatisticsName = "copyState";
    private static final String hashStatisticsName = "hashState";
    private static final String deleteStatisticsName = "deleteState";
    private final List<BenchmarkOperation<S, M>> mutableStateOperations;
    private final List<BenchmarkOperation<S, M>> immutableStateOperations;
    private final int immutableThreadCount;
    private final Duration roundPeriod;
    private final int statesInMemory;
    private final Duration spinUpTime;
    private final Duration testDuration;
    private final MutableStateManager<S> mutableStateManager;
    private final ImmutableStateManager<S> immutableStateManager;
    private final BlockingQueue<S> statesToHash;
    private final BlockingQueue<S> statesToDelete;
    private final M metadata;
    private final Map<String, BenchmarkStatistic> statistics;
    private final BenchmarkStatistic copyStatistics;
    private final BenchmarkStatistic hashStatistics;
    private final BenchmarkStatistic deleteStatistics;
    private volatile boolean alive;
    private volatile boolean captureStatistics;

    Benchmark(S initialState, M metadata, List<BenchmarkOperation<S, M>> mutableStateOperations, List<BenchmarkOperation<S, M>> immutableStateOperations, int immutableThreadCount, Duration roundPeriod, int statesInMemory, Duration spinUpTime, Duration testDuration) {
        this.mutableStateManager = new MutableStateManager<S>(initialState);
        this.metadata = metadata;
        this.mutableStateOperations = mutableStateOperations;
        this.immutableStateOperations = immutableStateOperations;
        this.immutableThreadCount = immutableThreadCount;
        this.roundPeriod = roundPeriod;
        this.statesInMemory = statesInMemory;
        this.spinUpTime = spinUpTime;
        this.testDuration = testDuration;
        this.immutableStateManager = new ImmutableStateManager();
        this.statesToHash = new LinkedBlockingQueue<S>();
        this.statesToDelete = new LinkedBlockingQueue<S>();
        this.alive = true;
        this.captureStatistics = false;
        this.statistics = new HashMap<String, BenchmarkStatistic>();
        this.copyStatistics = new BenchmarkStatistic(copyStatisticsName, testDuration);
        this.statistics.put(copyStatisticsName, this.copyStatistics);
        this.hashStatistics = new BenchmarkStatistic(hashStatisticsName, testDuration);
        this.statistics.put(hashStatisticsName, this.hashStatistics);
        this.deleteStatistics = new BenchmarkStatistic(deleteStatisticsName, testDuration);
        this.statistics.put(deleteStatisticsName, this.deleteStatistics);
        for (BenchmarkOperation<S, M> operation : mutableStateOperations) {
            this.registerStatisticForOperation(operation);
        }
        for (BenchmarkOperation<S, M> operation : immutableStateOperations) {
            this.registerStatisticForOperation(operation);
        }
    }

    private void waitWithStatusUpdates(Duration timeToWait) {
        Instant now;
        Duration timeRemaining;
        Instant startTime = Instant.now();
        while (!(timeRemaining = timeToWait.minus(Duration.between(startTime, now = Instant.now()))).isNegative()) {
            System.out.println(timeRemaining.toSeconds() + "s remaining");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void printSettings() {
        System.out.println("Mutable operations (1 thread)");
        for (BenchmarkOperation<S, M> operation : this.mutableStateOperations) {
            System.out.println("    - " + String.valueOf(operation));
        }
        System.out.println("Immutable operations (" + this.immutableThreadCount + " thread" + (this.immutableThreadCount == 1 ? "" : "s") + ")");
        for (BenchmarkOperation<S, M> operation : this.immutableStateOperations) {
            System.out.println("    - " + String.valueOf(operation));
        }
        System.out.println("Round period: " + this.roundPeriod.toMillis() + " milliseconds");
        System.out.println("States in memory: " + this.statesInMemory + " immutable states + 1 mutable state");
        System.out.println("Spin up time: " + this.spinUpTime.toSeconds() + " seconds");
        System.out.println("Test duration: " + this.testDuration.toSeconds() + " seconds");
    }

    public Collection<BenchmarkStatistic> run() throws InterruptedException {
        Thread copyThread = new Thread(this::copyThreadRunnable);
        Thread hashingThread = new Thread(this::hashingThreadRunnable);
        hashingThread.setName("HASHING THREAD");
        Thread deletionThread = new Thread(this::deletionThreadRunnable);
        Thread mutableThread = new Thread(this.buildOperationRunnable(this.copyOperationList(this.mutableStateOperations), this.mutableStateManager));
        LinkedList<Thread> immutableThreads = new LinkedList<Thread>();
        for (int i = 0; i < this.immutableThreadCount; ++i) {
            Thread immutableThread = new Thread(this.buildOperationRunnable(this.copyOperationList(this.immutableStateOperations), this.immutableStateManager));
            immutableThread.setName("immutable " + i);
            immutableThreads.add(immutableThread);
        }
        copyThread.start();
        hashingThread.start();
        deletionThread.start();
        mutableThread.start();
        immutableThreads.forEach(Thread::start);
        System.out.println("Waiting for " + this.spinUpTime.toSeconds() + " seconds to allow the system to reach a steady state");
        this.waitWithStatusUpdates(this.spinUpTime);
        this.captureStatistics = true;
        System.out.println("Spin up complete, gathering statistics");
        this.waitWithStatusUpdates(this.testDuration);
        this.captureStatistics = false;
        this.alive = false;
        System.out.println("joining copy thread");
        copyThread.join();
        System.out.println("joining hashing thread");
        hashingThread.join();
        System.out.println("joining deletion thread");
        deletionThread.join();
        System.out.println("joining mutable state thread");
        mutableThread.join();
        System.out.println("joining immutable state thread");
        for (Thread thread : immutableThreads) {
            thread.join();
        }
        System.out.println("finished joining all threads");
        return this.statistics.values();
    }

    private List<BenchmarkOperation<S, M>> copyOperationList(List<BenchmarkOperation<S, M>> operations) {
        ArrayList<BenchmarkOperation<S, M>> operationsCopy = new ArrayList<BenchmarkOperation<S, M>>(operations.size());
        for (BenchmarkOperation<S, M> operation : operations) {
            operationsCopy.add(operation.copy());
        }
        return operationsCopy;
    }

    private double getSumOfOperationWeights(List<BenchmarkOperation<S, M>> operations) {
        double sum = 0.0;
        for (BenchmarkOperation<S, M> operation : operations) {
            sum += operation.getWeight();
        }
        return sum;
    }

    private void registerStatisticForOperation(BenchmarkOperation<S, M> operation) {
        if (this.statistics.containsKey(operation.getName())) {
            throw new IllegalArgumentException("Operation names must be unique, but \"" + operation.getName() + "\" has already been used");
        }
        this.statistics.put(operation.getName(), new BenchmarkStatistic(operation.getName(), this.testDuration));
    }

    private BenchmarkStatistic getStatisticsForOperation(BenchmarkOperation<S, M> operation) {
        if (!this.statistics.containsKey(operation.getName())) {
            throw new IllegalArgumentException("No statistics registered for operation " + operation.getName());
        }
        return this.statistics.get(operation.getName());
    }

    private BenchmarkOperation<S, M> chooseRandomOperation(List<BenchmarkOperation<S, M>> operations, double totalWeight) {
        double choice = random.nextDouble() * totalWeight;
        double sum = 0.0;
        for (BenchmarkOperation<S, M> operation : operations) {
            if (!((sum += operation.getWeight()) >= choice)) continue;
            return operation;
        }
        throw new IllegalStateException("no operation was chosen");
    }

    private void runWithStatistics(RunnableWithException operation, BenchmarkStatistic statistic) {
        try {
            boolean captureStatistics = this.captureStatistics;
            if (captureStatistics) {
                statistic.start();
            }
            operation.run();
            if (captureStatistics) {
                statistic.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void copyThreadRunnable() {
        while (this.alive) {
            MerkleNode originalState;
            try {
                Thread.sleep(this.roundPeriod.toMillis());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
                return;
            }
            try (AutoCloseableWrapper<S> originalStateWrapper = this.mutableStateManager.getState();){
                originalState = (MerkleNode)originalStateWrapper.get();
                this.runWithStatistics(() -> this.mutableStateManager.setState(originalState.copy()), this.copyStatistics);
            }
            this.immutableStateManager.getStates().addLast(originalState);
            this.statesToHash.add(originalState);
            if (this.immutableStateManager.getStates().size() <= this.statesInMemory) continue;
            this.statesToDelete.add((MerkleNode)this.immutableStateManager.getStates().removeFirst());
        }
    }

    private void hashingThreadRunnable() {
        try {
            while (this.alive) {
                MerkleNode stateToHash = (MerkleNode)this.statesToHash.poll(100L, TimeUnit.MILLISECONDS);
                if (stateToHash == null) continue;
                this.runWithStatistics(() -> {
                    Future future = TestMerkleCryptoFactory.getInstance().digestTreeAsync(stateToHash);
                    future.get();
                }, this.hashStatistics);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private void deletionThreadRunnable() {
        try {
            while (this.alive) {
                MerkleNode stateToDelete = (MerkleNode)this.statesToDelete.poll(100L, TimeUnit.MILLISECONDS);
                if (stateToDelete == null) continue;
                this.runWithStatistics(() -> ((MerkleNode)stateToDelete).release(), this.deleteStatistics);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    private Runnable buildOperationRunnable(List<BenchmarkOperation<S, M>> operations, StateManager<S> stateManager) {
        double operationsWeight = this.getSumOfOperationWeights(operations);
        return () -> {
            while (this.alive) {
                BenchmarkOperation operation = this.chooseRandomOperation(operations, operationsWeight);
                BenchmarkStatistic statistic = this.getStatisticsForOperation(operation);
                operation.prepare(this.metadata, random);
                if (operation.shouldAbort()) continue;
                AutoCloseableWrapper merkleStateWrapper = stateManager.getState();
                try {
                    if (merkleStateWrapper.get() == null) continue;
                    this.runWithStatistics(() -> operation.execute((MerkleNode)merkleStateWrapper.get()), statistic);
                }
                finally {
                    if (merkleStateWrapper == null) continue;
                    merkleStateWrapper.close();
                }
            }
        };
    }

    @FunctionalInterface
    private static interface RunnableWithException {
        public void run() throws Exception;
    }
}

