/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.address;

import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;

public final class AddressBookValidator {
    private static final Logger logger = LogManager.getLogger(AddressBookValidator.class);

    private AddressBookValidator() {
    }

    public static boolean hasNonZeroWeight(AddressBook addressBook) {
        if (addressBook.getTotalWeight() <= 0L) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} has {} total weight", (Object)addressBook.getRound(), (Object)addressBook.getTotalWeight());
            return false;
        }
        return true;
    }

    public static boolean isNonEmpty(AddressBook addressBook) {
        if (addressBook.getSize() == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} is empty", (Object)addressBook.getRound());
            return false;
        }
        return true;
    }

    public static void validateNewAddressBook(@NonNull AddressBook oldAddressBook, @NonNull AddressBook newAddressBook) {
        int newSize = newAddressBook.getSize();
        if (newSize == 0) {
            throw new IllegalStateException("The new address book's size must be greater than 0");
        }
    }

    public static boolean isGenesisAddressBookValid(AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroWeight(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook);
    }

    public static boolean isNextAddressBookValid(AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroWeight(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook);
    }

    public static boolean sameExceptForWeight(@NonNull AddressBook addressBook1, @NonNull AddressBook addressBook2) {
        Objects.requireNonNull(addressBook1, "addressBook1 must not be null");
        Objects.requireNonNull(addressBook2, "addressBook2 must not be null");
        int addressBookSize = addressBook1.getSize();
        if (addressBookSize != addressBook2.getSize()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Address books have different sizes. Address book 1 has size {}, address book 2 has size {}.", (Object)addressBookSize, (Object)addressBook2.getSize());
            return false;
        }
        return IntStream.range(0, addressBookSize).mapToObj(i -> {
            NodeId nodeId1 = addressBook1.getNodeId(i);
            NodeId nodeId2 = addressBook2.getNodeId(i);
            Address address1 = addressBook1.getAddress(nodeId1);
            Address address2 = addressBook2.getAddress(nodeId2);
            if (address1 == null || address2 == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Address at index {} is null when accessed in order.", (Object)i);
                throw new IllegalStateException("Address at index " + i + " is null.");
            }
            boolean equal = address1.equalsWithoutWeight(address2);
            if (!equal) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Address at position {} is not the same between the two address books.", (Object)i);
            }
            return equal;
        }).reduce((left, right) -> left != false && right != false).orElse(false);
    }
}

