/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.lifecycle;

import com.hedera.pbj.runtime.Codec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record StateDefinition<K, V>(int stateId, @NonNull String stateKey, @Nullable Codec<K> keyCodec, @NonNull Codec<V> valueCodec, long maxKeysHint, boolean onDisk, boolean singleton, boolean queue) {
    private static final int NO_MAX = -1;

    public StateDefinition {
        if (singleton && queue) {
            throw new IllegalArgumentException("A state cannot both be 'singleton' and 'queue'");
        }
        if (singleton && onDisk) {
            throw new IllegalArgumentException("A state cannot both be 'singleton' and 'onDisk'");
        }
        if (onDisk && maxKeysHint <= 0L) {
            throw new IllegalArgumentException("You must specify the maxKeysHint when onDisk. Please see docs.");
        }
        if (queue && onDisk) {
            throw new IllegalArgumentException("A state cannot both be 'queue' and 'onDisk'");
        }
        if (!singleton && !queue) {
            Objects.requireNonNull(keyCodec, "keyCodec must be specified unless using singleton or queue types");
        }
        Objects.requireNonNull(stateKey, "stateKey must be specified");
        Objects.requireNonNull(valueCodec, "valueCodec must be specified");
    }

    public static <K, V> StateDefinition<K, V> inMemory(int stateId, @NonNull String stateKey, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, keyCodec, valueCodec, -1L, false, false, false);
    }

    public static <K, V> StateDefinition<K, V> onDisk(int stateId, @NonNull String stateKey, @NonNull Codec<K> keyCodec, @NonNull Codec<V> valueCodec, long maxKeysHint) {
        return new StateDefinition<K, V>(stateId, stateKey, keyCodec, valueCodec, maxKeysHint, true, false, false);
    }

    public static <K, V> StateDefinition<K, V> singleton(int stateId, @NonNull String stateKey, @NonNull Codec<V> valueCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, null, valueCodec, -1L, false, true, false);
    }

    public static <K, V> StateDefinition<K, V> queue(int stateId, @NonNull String stateKey, @NonNull Codec<V> elementCodec) {
        return new StateDefinition<K, V>(stateId, stateKey, null, elementCodec, -1L, false, false, true);
    }
}

