/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.sequence.map.SequenceMap;

public class NonDeterministicGeneration {
    public static final long GENERATION_UNDEFINED = 0L;
    public static final long FIRST_GENERATION = 1L;

    private NonDeterministicGeneration() {
    }

    public static void assignNGen(@NonNull PlatformEvent event, @NonNull SequenceMap<EventDescriptorWrapper, PlatformEvent> eventsWithParents) {
        long maxParentNGen = 0L;
        for (EventDescriptorWrapper parentDesc : event.getAllParents()) {
            PlatformEvent parent = eventsWithParents.get(parentDesc);
            if (parent == null) continue;
            maxParentNGen = Math.max(maxParentNGen, parent.getNGen());
        }
        long nGen = maxParentNGen == 0L ? 1L : maxParentNGen + 1L;
        event.setNGen(nGen);
    }
}

