/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilteredReadableStates
implements ReadableStates {
    private final ReadableStates delegate;
    private final Set<Integer> stateIds;

    public FilteredReadableStates(@NonNull ReadableStates delegate, @NonNull Set<Integer> stateIds) {
        this.delegate = Objects.requireNonNull(delegate);
        this.stateIds = stateIds.stream().filter(delegate::contains).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NonNull
    public <K, V> ReadableKVState<K, V> get(int stateId) {
        Objects.requireNonNull(stateId);
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find k/v state " + stateId);
        }
        return this.delegate.get(stateId);
    }

    @Override
    @NonNull
    public <T> ReadableSingletonState<T> getSingleton(int stateId) {
        Objects.requireNonNull(stateId);
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find singleton state " + stateId);
        }
        return this.delegate.getSingleton(stateId);
    }

    @Override
    @NonNull
    public <E> ReadableQueueState<E> getQueue(int stateId) {
        Objects.requireNonNull(stateId);
        if (!this.contains(stateId)) {
            throw new IllegalArgumentException("Could not find queue state " + stateId);
        }
        return this.delegate.getQueue(stateId);
    }

    @Override
    public boolean contains(int stateId) {
        return this.stateIds.contains(stateId);
    }

    @Override
    @NonNull
    public Set<Integer> stateIds() {
        return this.stateIds;
    }
}

