/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.iss;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.notification.Listener;
import com.swirlds.demo.iss.ISSTestingToolConfig;
import com.swirlds.demo.iss.ISSTestingToolConsensusStateEventHandler;
import com.swirlds.demo.iss.ISSTestingToolState;
import com.swirlds.demo.iss.TransactionGenerator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.DefaultSwirldMain;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.state.notifications.IssListener;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.notification.IssNotification;

public class ISSTestingToolMain
extends DefaultSwirldMain<ISSTestingToolState> {
    private static final Logger logger = LogManager.getLogger(ISSTestingToolMain.class);
    private static final SemanticVersion semanticVersion = SemanticVersion.newBuilder().major(1).build();
    private Platform platform;

    public ISSTestingToolMain() {
        logger.info(LogMarker.STARTUP.getMarker(), "constructor called in Main.");
    }

    public void init(Platform platform, NodeId id) {
        this.platform = platform;
        platform.getNotificationEngine().register(IssListener.class, (Listener)((IssListener)this::issListener));
    }

    private void issListener(IssNotification notification) {
    }

    public void run() {
        ISSTestingToolConfig testingToolConfig = (ISSTestingToolConfig)this.platform.getContext().getConfiguration().getConfigData(ISSTestingToolConfig.class);
        new TransactionGenerator(new Random(), this.platform, this.getTransactionPool(), testingToolConfig.transactionsPerSecond()).start();
    }

    @NonNull
    public ISSTestingToolState newStateRoot() {
        ISSTestingToolState state = new ISSTestingToolState();
        TestingAppStateInitializer.DEFAULT.initConsensusModuleStates((MerkleNodeState)state);
        return state;
    }

    public Function<VirtualMap, ISSTestingToolState> stateRootFromVirtualMap() {
        throw new UnsupportedOperationException();
    }

    public ConsensusStateEventHandler<ISSTestingToolState> newConsensusStateEvenHandler() {
        return new ISSTestingToolConsensusStateEventHandler();
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    @Nullable
    public List<Class<? extends Record>> getConfigDataTypes() {
        return List.of(ISSTestingToolConfig.class);
    }

    static {
        try {
            logger.info(LogMarker.STARTUP.getMarker(), "Registering ISSTestingToolState with ConstructableRegistry");
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(ISSTestingToolState.class, () -> {
                ISSTestingToolState issTestingToolState = new ISSTestingToolState();
                return issTestingToolState;
            }));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
            logger.info(LogMarker.STARTUP.getMarker(), "ISSTestingToolState is registered with ConstructableRegistry");
        }
        catch (ConstructableRegistryException e) {
            logger.error(LogMarker.STARTUP.getMarker(), "Failed to register ISSTestingToolState", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

