/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableDoubleSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

@ServiceProvider(value=ImmutableDoubleSetFactory.class)
public class ImmutableDoubleSetFactoryImpl
implements ImmutableDoubleSetFactory {
    public static final ImmutableDoubleSetFactory INSTANCE = new ImmutableDoubleSetFactoryImpl();

    public ImmutableDoubleSet empty() {
        return ImmutableDoubleEmptySet.INSTANCE;
    }

    public ImmutableDoubleSet of() {
        return this.empty();
    }

    public ImmutableDoubleSet with() {
        return this.empty();
    }

    public ImmutableDoubleSet of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleSet with(double one) {
        return new ImmutableDoubleSingletonSet(one);
    }

    public ImmutableDoubleSet of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleSet with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return DoubleHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableDoubleSet ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleSet withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleSet) {
            return (ImmutableDoubleSet)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableDoubleSet ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableDoubleSet withAll(Iterable<Double> iterable) {
        return DoubleSets.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableDoubleSet ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public ImmutableDoubleSet withAll(DoubleStream items) {
        MutableDoubleSet newSet = DoubleSets.mutable.empty();
        items.forEach(arg_0 -> ((MutableDoubleSet)newSet).add(arg_0));
        return newSet.toImmutable();
    }
}

