/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.console;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.handler.AbstractLogHandler;
import com.swirlds.logging.api.internal.format.FormattedLinePrinter;
import com.swirlds.logging.io.BufferedOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ConsoleHandler
extends AbstractLogHandler {
    private static final int BUFFER_CAPACITY = 8192;
    private final FormattedLinePrinter format;
    private final OutputStream outputStream;

    public ConsoleHandler(@NonNull String handlerName, @NonNull Configuration configuration, boolean buffered) {
        super(handlerName, configuration);
        this.format = FormattedLinePrinter.createForHandler(handlerName, configuration);
        this.outputStream = buffered ? new BufferedOutputStream(System.out, 8192) : System.out;
    }

    @Override
    public void handle(@NonNull LogEvent event) {
        StringBuilder builder = new StringBuilder();
        this.format.print(builder, event);
        try {
            this.outputStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException exception) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to write to console", exception);
        }
    }

    @Override
    public void stopAndFinalize() {
        try {
            this.outputStream.flush();
        }
        catch (IOException exception) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to close file output stream", exception);
        }
    }
}

