/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.io;

import com.swirlds.logging.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class RolloverFileOutputStream
extends OutputStream {
    protected final Path logPath;
    private final int maxFiles;
    private final long maxFileSize;
    private final boolean append;
    private long remainingSize;
    private FileOutputStream outputStream;
    private final String baseName;
    private final String extension;
    private final int indexLength;
    private int index;

    protected RolloverFileOutputStream(@NonNull Path logPath, long maxFileSize, boolean append, int maxFiles) {
        this.logPath = logPath.toAbsolutePath().getParent();
        this.append = append;
        this.maxFiles = maxFiles;
        this.maxFileSize = maxFileSize;
        String baseFile = logPath.getFileName().toString();
        int lastDotIndex = baseFile.lastIndexOf(".");
        if (lastDotIndex > 0) {
            this.baseName = baseFile.substring(0, lastDotIndex);
            this.extension = baseFile.substring(lastDotIndex + 1);
        } else {
            this.baseName = baseFile;
            this.extension = "";
        }
        this.index = 0;
        this.indexLength = String.valueOf(maxFiles).length();
        try {
            this.outputStream = new FileOutputStream(logPath.toString(), this.append);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Log file cannot be created", e);
        }
        if (Files.exists(logPath, new LinkOption[0]) && append) {
            this.remainingSize = maxFileSize - logPath.toFile().length();
        } else {
            this.remainingSize = maxFileSize;
            this.roll();
        }
    }

    @Override
    public synchronized void write(@NonNull byte[] bytes, int offset, int length) throws IOException {
        ((OutputStream)this.outputStream).write(bytes, offset, length);
        this.remainingSize -= (long)length;
        this.rollIfNeeded();
    }

    @Override
    public synchronized void write(@NonNull byte[] bytes) throws IOException {
        ((OutputStream)this.outputStream).write(bytes);
        this.remainingSize -= (long)bytes.length;
        this.rollIfNeeded();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        ((OutputStream)this.outputStream).write(b);
        --this.remainingSize;
        this.rollIfNeeded();
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.flush();
        ((OutputStream)this.outputStream).close();
    }

    private String dotExtension() {
        if (this.extension.isEmpty()) {
            return "";
        }
        return "." + this.extension;
    }

    private void rollIfNeeded() {
        if (this.remainingSize <= 0L) {
            this.roll();
        }
    }

    private String logFileName() {
        return this.baseName + this.dotExtension();
    }

    protected Path logFilePath() {
        return this.logPath.resolve(this.logFileName());
    }

    private void roll() {
        long maxIndex = this.maxFiles - 1;
        int currentIndex = this.index;
        Path newPath = this.getPathFor(currentIndex);
        while (Files.exists(newPath, new LinkOption[0]) && (long)currentIndex <= maxIndex) {
            newPath = this.getPathFor(++currentIndex % this.maxFiles);
        }
        if ((long)currentIndex > maxIndex) {
            currentIndex = this.index;
            newPath = this.getPathFor(currentIndex % this.maxFiles);
        }
        File file = this.logFilePath().toFile();
        try {
            this.outputStream.close();
            Files.move(file.toPath(), newPath, StandardCopyOption.REPLACE_EXISTING);
            this.outputStream = new FileOutputStream(file, this.append);
        }
        catch (IOException e) {
            throw new IllegalStateException("Something happened while rolling over", e);
        }
        this.index = currentIndex;
        this.remainingSize = this.maxFileSize;
    }

    private Path getPathFor(int index) {
        return this.logPath.resolve(this.baseName + "." + StringUtils.toPaddedDigitsString(index, this.indexLength) + this.dotExtension());
    }
}

