/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.actions;

import com.swirlds.demo.platform.actions.Action;
import com.swirlds.demo.platform.actions.Trigger;
import java.util.function.Supplier;

public class TriggeredAction<N, S> {
    private Trigger<N, S> trigger;
    private Action<N, S> action;
    private boolean autoReset = false;

    public TriggeredAction() {
    }

    public TriggeredAction(Trigger<N, S> trigger, Action<N, S> action) {
        this();
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        if (action == null) {
            throw new IllegalArgumentException("action");
        }
        this.trigger = trigger;
        this.action = action;
    }

    public void check(N node, S state) {
        if (this.trigger.test(node, state)) {
            this.action.execute(node, state);
            if (this.autoReset) {
                this.reset();
            }
        }
    }

    public void check(N node, Supplier<S> stateSupplier) {
        if (stateSupplier == null) {
            throw new IllegalArgumentException("stateSupplier");
        }
        this.check(node, stateSupplier.get());
    }

    public void check(Supplier<N> nodeSupplier, Supplier<S> stateSupplier) {
        if (nodeSupplier == null) {
            throw new IllegalArgumentException("nodeSupplier");
        }
        this.check(nodeSupplier.get(), stateSupplier);
    }

    public TriggeredAction<N, S> withAutoReset() {
        this.autoReset = true;
        return this;
    }

    public TriggeredAction<N, S> withoutAutoReset() {
        this.autoReset = false;
        return this;
    }

    public void reset() {
    }

    public Trigger<N, S> getTrigger() {
        return this.trigger;
    }

    public TriggeredAction<N, S> withTrigger(Trigger<N, S> trigger) {
        this.trigger = trigger;
        return this;
    }

    public Action<N, S> getAction() {
        return this.action;
    }

    public TriggeredAction<N, S> withAction(Action<N, S> action) {
        this.action = action;
        return this;
    }
}

