/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.expiration;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.demo.merkle.map.FCMFamily;
import com.swirlds.demo.merkle.map.MapValueFCQ;
import com.swirlds.demo.merkle.map.internal.DummyExpectedFCMFamily;
import com.swirlds.demo.merkle.map.internal.ExpectedFCMFamily;
import com.swirlds.demo.platform.expiration.ExpirationRecordEntry;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.lifecycle.ExpectedValue;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import com.swirlds.merkle.test.fixtures.map.pta.TransactionRecord;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.hiero.consensus.model.node.NodeId;

public class ExpirationUtils {
    private static final Marker EXPIRATION_MARKER = MarkerManager.getMarker((String)"EXPIRATION");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO_FCQ_SIZE");
    private static final Logger logger = LogManager.getLogger(ExpirationUtils.class);

    public static void addRecordsDuringRebuild(FCMFamily fcmFamily, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        long startTime = System.nanoTime();
        logger.info(EXPIRATION_MARKER, "Start to build expirationQueue");
        MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> fcqMap = fcmFamily.getAccountFCQMap();
        for (Map.Entry entry : fcqMap.entrySet()) {
            FCQueue records = ((MapValueFCQ)((Object)entry.getValue())).getRecords();
            if (records.isEmpty()) continue;
            expirationQueue.offer(new ExpirationRecordEntry(((TransactionRecord)records.peek()).getExpirationTime(), (MapKey)entry.getKey()));
            accountsWithExpiringRecords.add((MapKey)entry.getKey());
        }
        long timeTakenMs = (System.nanoTime() - startTime) / 1000000L;
        logger.info(EXPIRATION_MARKER, "Finish building expirationQueue in {} ms, expirationQueue size: {}, accountsWithExpiringRecords size: {}, FCQ Account Map size: {}", (Object)timeTakenMs, (Object)expirationQueue.size(), (Object)accountsWithExpiringRecords.size(), (Object)fcqMap.size());
    }

    private static void recalculateHashAfterPurge(MapKey id, ExpectedFCMFamily expectedFCMFamily) {
        if (expectedFCMFamily instanceof DummyExpectedFCMFamily) {
            return;
        }
        ExpectedValue newHashedValue = expectedFCMFamily.getExpectedMap().get(id);
        expectedFCMFamily.getExpectedMap().put(id, newHashedValue.setHash(null));
        logger.trace(EXPIRATION_MARKER, "New Hash set after purging FCQ transaction records {} for mapKey {}", (Object)expectedFCMFamily.getExpectedMap().get(id).getHash(), (Object)id);
    }

    public static long purgeTransactionRecords(long timestamp, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords, MapKey id, FCMFamily fcmFamily, ExpectedFCMFamily expectedFCMFamily) {
        if (fcmFamily == null || fcmFamily.getAccountFCQMap() == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "FCMFamily is null, so could not rebuild Expiration Queue");
            return 0L;
        }
        if (!fcmFamily.getAccountFCQMap().containsKey((Object)id)) {
            accountsWithExpiringRecords.remove(id);
            return 0L;
        }
        MapValueFCQ fcqValue = (MapValueFCQ)fcmFamily.getAccountFCQMap().getForModify((Object)id);
        long sizeBeforePurge = fcqValue.getRecordsSize();
        FCQueue updatedRecords = fcqValue.getRecords();
        while (ExpirationUtils.isExpiredRecordPresent(updatedRecords, timestamp)) {
            updatedRecords.poll();
        }
        fcmFamily.getAccountFCQMap().replace((Object)id, (MerkleNode)fcqValue);
        if (fcqValue.getRecords().isEmpty()) {
            accountsWithExpiringRecords.remove(id);
        } else {
            long newEarliestExpiry = ((TransactionRecord)fcqValue.getRecords().peek()).getExpirationTime();
            ExpirationRecordEntry newEre = new ExpirationRecordEntry(newEarliestExpiry, id);
            expirationQueue.offer(newEre);
        }
        ExpirationUtils.recalculateHashAfterPurge(id, expectedFCMFamily);
        return sizeBeforePurge - (long)fcqValue.getRecordsSize();
    }

    public static boolean isRecordExpirationValid(long lastPurgeTimestamp, MerkleMap<MapKey, MapValueFCQ<TransactionRecord>> fcqMap, NodeId selfId) {
        boolean passExpirationCheck = true;
        for (Map.Entry entry : fcqMap.entrySet()) {
            FCQueue records = ((MapValueFCQ)((Object)entry.getValue())).getRecords();
            if (!ExpirationUtils.isExpiredRecordPresent(records, lastPurgeTimestamp)) continue;
            passExpirationCheck = false;
            logger.info(ERROR, "{} Fails Expiration Checking. lastPurgeTimestamp: {}; MapKey: {}; first record's expirationTime: {}", (Object)selfId, (Object)lastPurgeTimestamp, entry.getKey(), (Object)((TransactionRecord)records.peek()).getExpirationTime());
        }
        return passExpirationCheck;
    }

    private static boolean isExpiredRecordPresent(FCQueue<TransactionRecord> records, long lastPurgeTimestamp) {
        return !records.isEmpty() && ((TransactionRecord)records.peek()).getExpirationTime() <= lastPurgeTimestamp;
    }

    public static void addRecordToExpirationQueue(TransactionRecord record, MapKey mapKey, BlockingQueue<ExpirationRecordEntry> expirationQueue, Set<MapKey> accountsWithExpiringRecords) {
        if (expirationQueue == null || accountsWithExpiringRecords == null) {
            logger.info(MARKER, "TransactionRecord could not be added to expirationQueue, as expirationQueue {} or accountsWithExpiringRecords {} is null", expirationQueue, accountsWithExpiringRecords);
            return;
        }
        if (accountsWithExpiringRecords.isEmpty() || !accountsWithExpiringRecords.contains(mapKey)) {
            expirationQueue.offer(new ExpirationRecordEntry(record.getExpirationTime(), mapKey));
            accountsWithExpiringRecords.add(mapKey);
        }
    }
}

