/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Signature;
import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.ThresholdSignature;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class SignatureJsonCodec
implements JsonCodec<Signature> {
    public static final OneOf<Signature.SignatureOneOfType> SIGNATURE_UNSET = new OneOf((Enum)Signature.SignatureOneOfType.UNSET, null);

    @NonNull
    public Signature parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            OneOf temp_signature = SIGNATURE_UNSET;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contract": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.CONTRACT, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block18;
                    }
                    case "ed25519": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.ED25519, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block18;
                    }
                    case "RSA3072": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.RSA_3072, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block18;
                    }
                    case "ECDSA384": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.ECDSA_384, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block18;
                    }
                    case "thresholdSignature": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.THRESHOLD_SIGNATURE, ThresholdSignature.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block18;
                    }
                    case "signatureList": {
                        temp_signature = new OneOf((Enum)Signature.SignatureOneOfType.SIGNATURE_LIST, SignatureList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1));
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Signature(temp_signature);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Signature data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.signature().kind() == Signature.SignatureOneOfType.CONTRACT) {
            fieldLines.add(JsonTools.field((String)"contract", (Bytes)data.contract()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ED25519) {
            fieldLines.add(JsonTools.field((String)"ed25519", (Bytes)data.ed25519()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.RSA_3072) {
            fieldLines.add(JsonTools.field((String)"RSA3072", (Bytes)data.rsa3072()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.ECDSA_384) {
            fieldLines.add(JsonTools.field((String)"ECDSA384", (Bytes)data.ecdsa384()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.THRESHOLD_SIGNATURE) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"thresholdSignature", ThresholdSignature.JSON, (Object)data.thresholdSignature()));
        }
        if (data.signature().kind() == Signature.SignatureOneOfType.SIGNATURE_LIST) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"signatureList", SignatureList.JSON, (Object)data.signatureList()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

