/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.TeacherSubtree;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class TeachingSynchronizer {
    private static final String WORK_GROUP_NAME = "teaching-synchronizer";
    private static final Logger logger = LogManager.getLogger(TeachingSynchronizer.class);
    private final MerkleDataInputStream inputStream;
    private final MerkleDataOutputStream outputStream;
    private final Queue<TeacherSubtree> subtrees;
    private final Runnable breakConnection;
    private final ThreadManager threadManager;
    protected final ReconnectConfig reconnectConfig;
    private final Time time;

    public TeachingSynchronizer(@NonNull Configuration configuration, @NonNull Time time, @NonNull ThreadManager threadManager, @NonNull MerkleDataInputStream in, @NonNull MerkleDataOutputStream out, @NonNull MerkleNode root, @Nullable Runnable breakConnection, @NonNull ReconnectConfig reconnectConfig) {
        this.time = Objects.requireNonNull(time);
        this.threadManager = Objects.requireNonNull(threadManager, "threadManager must not be null");
        this.inputStream = Objects.requireNonNull(in, "in must not be null");
        this.outputStream = Objects.requireNonNull(out, "out must not be null");
        this.subtrees = new LinkedList<TeacherSubtree>();
        if (root instanceof CustomReconnectRoot) {
            CustomReconnectRoot customReconnectRoot = (CustomReconnectRoot)root;
            this.subtrees.add(new TeacherSubtree(root, customReconnectRoot.buildTeacherView(reconnectConfig)));
        } else {
            this.subtrees.add(new TeacherSubtree(configuration, root));
        }
        this.breakConnection = breakConnection;
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig, "reconnectConfig must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void synchronize() throws InterruptedException {
        try {
            while (!this.subtrees.isEmpty()) {
                TeacherSubtree subtree = this.subtrees.remove();
                try {
                    subtree.getView().waitUntilReady();
                    this.sendTree(subtree.getRoot(), subtree.getView());
                }
                finally {
                    if (subtree == null) continue;
                    subtree.close();
                }
            }
            return;
        }
        finally {
            Iterator iterator = this.subtrees.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                TeacherSubtree subtree = (TeacherSubtree)iterator.next();
                subtree.close();
            }
        }
    }

    private <T> void sendTree(MerkleNode root, TeacherTreeView<T> view) throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "sending tree rooted at {} with route {}", (Object)(root == null ? null : root.getClass().getName()), root == null ? "[]" : root.getRoute());
        AtomicReference firstReconnectException = new AtomicReference();
        StandardWorkGroup workGroup = this.createStandardWorkGroup(this.threadManager, this.breakConnection, cause -> {
            while (cause != null) {
                SocketException socketEx;
                if (cause instanceof SocketException && (socketEx = (SocketException)cause).getMessage().equalsIgnoreCase("Connection reset by peer")) {
                    logger.info(LogMarker.RECONNECT.getMarker(), "Connection reset while sending tree at {} with route {}. Aborting", (Object)(root == null ? null : root.getClass().getName()), root == null ? "[]" : root.getRoute());
                    return true;
                }
                cause = cause.getCause();
            }
            firstReconnectException.compareAndSet(null, cause);
            return false;
        });
        view.startTeacherTasks(this, this.time, workGroup, this.inputStream, this.outputStream, this.subtrees);
        workGroup.waitForTermination();
        if (workGroup.hasExceptions()) {
            view.abort();
            throw new MerkleSynchronizationException("Synchronization failed with exceptions", (Throwable)firstReconnectException.get());
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "finished sending tree");
    }

    protected StandardWorkGroup createStandardWorkGroup(ThreadManager threadManager, Runnable breakConnection, Function<Throwable, Boolean> exceptionListener) {
        return new StandardWorkGroup(threadManager, WORK_GROUP_NAME, breakConnection, exceptionListener);
    }

    public <T extends SelfSerializable> AsyncOutputStream<T> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new AsyncOutputStream(out, workGroup, this.reconnectConfig);
    }
}

