/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.StatEntry;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PlatformStatEntry
extends AbstractMetric
implements StatEntry {
    @NonNull
    private final Metric.DataType dataType;
    @Nullable
    private final StatsBuffered buffered;
    @Nullable
    private final Consumer<Double> reset;
    @NonNull
    private final Supplier<Object> statsStringSupplier;
    @NonNull
    private final Supplier<Object> resetStatsStringSupplier;
    private final double halfLife;

    public PlatformStatEntry(@NonNull StatEntry.Config<?> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.buffered = config.getBuffered();
        this.reset = config.getReset();
        this.statsStringSupplier = config.getStatsStringSupplier();
        this.resetStatsStringSupplier = config.getResetStatsStringSupplier();
        this.halfLife = config.getHalfLife();
        if (config.getInit() != null) {
            config.getInit().apply(this.halfLife);
        }
    }

    @NonNull
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @Override
    @Nullable
    public StatsBuffered getBuffered() {
        return this.buffered;
    }

    @Override
    @Nullable
    public Consumer<Double> getReset() {
        return this.reset;
    }

    @Override
    @NonNull
    public Supplier<Object> getStatsStringSupplier() {
        return this.statsStringSupplier;
    }

    @Override
    @NonNull
    public Supplier<Object> getResetStatsStringSupplier() {
        return this.resetStatsStringSupplier;
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        if (this.buffered == null) {
            return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.resetStatsStringSupplier.get()));
        }
        double max = this.buffered.getMax();
        double min = this.buffered.getMin();
        double stdDev = this.buffered.getStdDev();
        Object value = this.resetStatsStringSupplier.get();
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, value), new Snapshot.SnapshotEntry(Metric.ValueType.MAX, (Object)max), new Snapshot.SnapshotEntry(Metric.ValueType.MIN, (Object)min), new Snapshot.SnapshotEntry(Metric.ValueType.STD_DEV, (Object)stdDev));
    }

    public void reset() {
        if (this.reset != null) {
            this.reset.accept(this.halfLife);
        } else if (this.buffered != null) {
            this.buffered.reset(this.halfLife);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.statsStringSupplier.get()).toString();
    }
}

