/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;

public interface Codec<T> {
    public static final int DEFAULT_MAX_SIZE = 0x200000;

    @NonNull
    public T parse(@NonNull ReadableSequentialData var1, boolean var2, boolean var3, int var4, int var5) throws ParseException;

    @NonNull
    default public T parse(@NonNull ReadableSequentialData input, boolean strictMode, boolean parseUnknownFields, int maxDepth) throws ParseException {
        return this.parse(input, strictMode, parseUnknownFields, maxDepth, 0x200000);
    }

    @NonNull
    default public T parse(@NonNull ReadableSequentialData input, boolean strictMode, int maxDepth) throws ParseException {
        return this.parse(input, strictMode, false, maxDepth);
    }

    @NonNull
    default public T parse(@NonNull Bytes bytes, boolean strictMode, int maxDepth) throws ParseException {
        return this.parse(bytes.toReadableSequentialData(), strictMode, maxDepth);
    }

    @NonNull
    default public T parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parse(input, false, Integer.MAX_VALUE);
    }

    @NonNull
    default public T parse(@NonNull Bytes bytes) throws ParseException {
        return this.parse(bytes.toReadableSequentialData());
    }

    @NonNull
    default public T parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parse(input, true, Integer.MAX_VALUE);
    }

    @NonNull
    default public T parseStrict(@NonNull Bytes bytes) throws ParseException {
        return this.parseStrict(bytes.toReadableSequentialData());
    }

    public void write(@NonNull T var1, @NonNull WritableSequentialData var2) throws IOException;

    default public int write(@NonNull T item, @NonNull byte[] output, int startOffset) {
        BufferedData bufferedData = BufferedData.wrap(output, startOffset, output.length - startOffset);
        try {
            this.write(item, bufferedData);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (int)bufferedData.position();
    }

    public int measure(@NonNull ReadableSequentialData var1) throws ParseException;

    public int measureRecord(T var1);

    public boolean fastEquals(@NonNull T var1, @NonNull ReadableSequentialData var2) throws ParseException;

    default public Bytes toBytes(@NonNull T item) {
        byte[] bytes = new byte[this.measureRecord(item)];
        BufferedData bufferedData = BufferedData.wrap(bytes);
        try {
            this.write(item, bufferedData);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Bytes.wrap(bytes);
    }

    public T getDefaultInstance();
}

