/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli.utils;

import com.swirlds.platform.testreader.JrsReportData;
import com.swirlds.platform.testreader.JrsTestIdentifier;
import com.swirlds.platform.testreader.JrsTestMetadata;
import com.swirlds.platform.testreader.JrsTestReader;
import com.swirlds.platform.util.VirtualTerminal;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;

public class JtrUtils {
    private JtrUtils() {
    }

    @NonNull
    public static Map<JrsTestIdentifier, JrsTestMetadata> getTestMetadata(@Nullable Path metadataFile) {
        if (metadataFile == null) {
            System.out.println("No metadata file specified.");
            return new HashMap<JrsTestIdentifier, JrsTestMetadata>();
        }
        if (!Files.exists(metadataFile, new LinkOption[0])) {
            System.out.println("No metadata file found at " + String.valueOf(metadataFile) + ". ");
            return new HashMap<JrsTestIdentifier, JrsTestMetadata>();
        }
        return JrsTestReader.parseMetadataFile(metadataFile);
    }

    @NonNull
    public static JrsReportData scrapeTestData(@NonNull String bucketPrefix, @NonNull String testDirectory, int days, int threads) {
        VirtualTerminal terminal = new VirtualTerminal().setProgressIndicatorEnabled(true).setThrowOnError(true);
        Instant now = Instant.now();
        terminal.run("gsutil");
        boolean hasSlash = bucketPrefix.endsWith("/") || testDirectory.startsWith("/");
        String rootDirectory = bucketPrefix + (hasSlash ? "" : "/") + testDirectory;
        return JrsTestReader.findTestResults(terminal, Executors.newFixedThreadPool(threads), rootDirectory, now, Duration.ofDays(days));
    }
}

