/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework.validation;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusOutput;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusOutputValidation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;
import org.hiero.consensus.model.event.PlatformEvent;

public final class OutputNoEventsLostValidation
implements ConsensusOutputValidation {
    private static final ConsensusConfig CONFIG = (ConsensusConfig)new TestConfigBuilder().getOrCreateConfig().getConfigData(ConsensusConfig.class);

    private OutputNoEventsLostValidation() {
    }

    @Override
    public void validate(@NonNull ConsensusOutput output, @NonNull ConsensusOutput ignored) {
        Map<Hash, PlatformEvent> stale = output.getStaleEvents().stream().collect(Collectors.toMap(Hashable::getHash, e -> e));
        Map<Hash, PlatformEvent> cons = output.getConsensusRounds().stream().flatMap(r -> r.getConsensusEvents().stream()).collect(Collectors.toMap(PlatformEvent::getHash, e -> e));
        if (output.getConsensusRounds().isEmpty()) {
            return;
        }
        long nonAncientThreshold = RoundCalculationUtils.getAncientThreshold((int)CONFIG.roundsNonAncient(), (ConsensusSnapshot)output.getConsensusRounds().getLast().getSnapshot());
        for (PlatformEvent event : output.getAddedEvents()) {
            if (event.getBirthRound() >= nonAncientThreshold || stale.containsKey(event.getHash()) != cons.containsKey(event.getHash())) continue;
            Assertions.fail((String)String.format("An ancient event should be either stale or consensus, but not both!\nnonAncientGen=%d, Event %s, stale=%s, consensus=%s", nonAncientThreshold, event.getDescriptor(), stale.containsKey(event.getHash()), cons.containsKey(event.getHash())));
        }
    }
}

