/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.util.iterator;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class SkippingIterator<T>
implements Iterator<T> {
    private int cursor;
    private final T[] array;
    private final Set<Integer> skipIndices;
    private int lastReturnableIndex;

    public SkippingIterator(T[] array, Set<Integer> skipIndices) {
        Objects.requireNonNull(array, "array must not be null");
        this.array = array;
        this.skipIndices = skipIndices == null ? Collections.emptySet() : Set.copyOf(skipIndices);
        this.lastReturnableIndex = -1;
        for (int i = array.length - 1; i >= 0; --i) {
            if (this.skipIndices.contains(i)) continue;
            this.lastReturnableIndex = i;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.array.length && this.cursor <= this.lastReturnableIndex;
    }

    @Override
    public T next() {
        while (this.skipIndices.contains(this.cursor)) {
            ++this.cursor;
        }
        int i = this.cursor;
        if (i > this.lastReturnableIndex) {
            throw new NoSuchElementException();
        }
        this.cursor = i + 1;
        return this.array[i];
    }
}

