/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.hashgraph.internal;

import com.swirlds.platform.gui.hashgraph.internal.HashgraphGuiUtils;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hiero.consensus.model.roster.AddressBook;

public class AddressBookMetadata {
    private final AddressBook addressBook;
    private final int numMembers;
    private final String[] memberLabels;
    private final int numColumns;
    private final int[][] mems2col;
    private final int[][] col2mems;

    public AddressBookMetadata(@NonNull AddressBook addressBook, boolean expand) {
        int i;
        int m;
        this.addressBook = Objects.requireNonNull(addressBook, "addressBook must not be null");
        this.numMembers = m = addressBook.getSize();
        this.memberLabels = new String[m];
        for (i = 0; i < m; ++i) {
            this.memberLabels[i] = "ID:%d W:%d".formatted(addressBook.getNodeId(i).id(), addressBook.getAddress(addressBook.getNodeId(i)).getWeight());
        }
        if (this.numMembers == 1) {
            this.numColumns = 1;
            this.col2mems = new int[][]{{0, -1}};
            this.mems2col = new int[][]{{0}};
            return;
        }
        if (this.numMembers == 2) {
            this.numColumns = 2;
            this.col2mems = new int[][]{{0, -1}, {1, -1}};
            this.mems2col = new int[][]{{0, 1}, {0, 0}};
            return;
        }
        if (!expand) {
            this.numColumns = m;
            this.mems2col = new int[m][m];
            this.col2mems = new int[this.numColumns][2];
            for (i = 0; i < m; ++i) {
                this.col2mems[i][0] = i;
                this.col2mems[i][1] = -1;
                for (int j = 0; j < m; ++j) {
                    this.mems2col[i][j] = j;
                }
            }
            return;
        }
        this.numColumns = m * (m - 1) / 2 + 1;
        this.mems2col = new int[m][m];
        this.col2mems = new int[this.numColumns][2];
        for (int x = 0; x < m * (m - 1) / 2 + 1; ++x) {
            int d1 = m % 2 == 1 ? 0 : 2 * ((x - 1) / (m - 1));
            this.col2mems[x][0] = HashgraphGuiUtils.col2mem(m, d1 + x);
            this.col2mems[x][1] = m % 2 == 1 || x % (m - 1) > 0 || x == 0 || x == m * (m - 1) / 2 ? -1 : HashgraphGuiUtils.col2mem(m, d1 + x + 2);
            int d = m % 2 == 1 ? 0 : 2 * (x / (m - 1));
            int a = HashgraphGuiUtils.col2mem(m, d + x);
            int b = HashgraphGuiUtils.col2mem(m, d + x + 1);
            if (x >= m * (m - 1) / 2) continue;
            this.mems2col[b][a] = x;
            this.mems2col[a][b] = x + 1;
        }
    }

    public int getNumMembers() {
        return this.numMembers;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int mems2col(@Nullable EventImpl e1, @NonNull EventImpl e2) {
        Objects.requireNonNull(e2, "e2 must not be null");
        int e2Index = this.addressBook.getIndexOfNodeId(e2.getCreatorId());
        if (e1 != null) {
            int e1Index = this.addressBook.getIndexOfNodeId(e1.getCreatorId());
            return this.mems2col[e1Index][e2Index];
        }
        return this.mems2col[e2Index == 0 ? (this.getNumColumns() == 1 ? 0 : 1) : 0][e2Index];
    }

    public String getLabel(int i) {
        if (this.col2mems[i][1] == -1) {
            return this.memberLabels[this.col2mems[i][0]];
        }
        return this.memberLabels[this.col2mems[i][0]] + "|" + this.memberLabels[this.col2mems[i][1]];
    }
}

