/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockstream.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.node.state.blockstream.schema.BlockStreamInfoSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BlockStreamInfoJsonCodec
implements JsonCodec<BlockStreamInfo> {
    @NonNull
    public BlockStreamInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_block_number = 0L;
            Timestamp temp_block_time = null;
            Bytes temp_trailing_output_hashes = Bytes.EMPTY;
            Bytes temp_trailing_block_hashes = Bytes.EMPTY;
            Bytes temp_input_tree_root_hash = Bytes.EMPTY;
            Bytes temp_start_of_block_state_hash = Bytes.EMPTY;
            int temp_num_preceding_state_changes_items = 0;
            List<Bytes> temp_rightmost_preceding_state_changes_tree_hashes = Collections.emptyList();
            Timestamp temp_block_end_time = null;
            boolean temp_post_upgrade_work_done = false;
            SemanticVersion temp_creation_software_version = null;
            Timestamp temp_last_interval_process_time = null;
            Timestamp temp_last_handle_time = null;
            Bytes temp_consensus_header_tree_root_hash = Bytes.EMPTY;
            Bytes temp_trace_data_tree_root_hash = Bytes.EMPTY;
            Bytes temp_output_tree_root_hash = Bytes.EMPTY;
            block38: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "blockNumber": {
                        temp_block_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block38;
                    }
                    case "blockTime": {
                        temp_block_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block38;
                    }
                    case "trailingOutputHashes": {
                        temp_trailing_output_hashes = Bytes.fromBase64((String)JsonTools.checkSize((String)"trailing_output_hashes", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "trailingBlockHashes": {
                        temp_trailing_block_hashes = Bytes.fromBase64((String)JsonTools.checkSize((String)"trailing_block_hashes", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "inputTreeRootHash": {
                        temp_input_tree_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"input_tree_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "startOfBlockStateHash": {
                        temp_start_of_block_state_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"start_of_block_state_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "numPrecedingStateChangesItems": {
                        temp_num_preceding_state_changes_items = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block38;
                    }
                    case "rightmostPrecedingStateChangesTreeHashes": {
                        temp_rightmost_preceding_state_changes_tree_hashes = JsonTools.checkSize((String)"rightmost_preceding_state_changes_tree_hashes", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> Bytes.fromBase64((String)JsonTools.checkSize((String)"rightmost_preceding_state_changes_tree_hashes", (String)v.STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)))).toList();
                        continue block38;
                    }
                    case "blockEndTime": {
                        temp_block_end_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block38;
                    }
                    case "postUpgradeWorkDone": {
                        temp_post_upgrade_work_done = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block38;
                    }
                    case "creationSoftwareVersion": {
                        temp_creation_software_version = (SemanticVersion)SemanticVersion.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block38;
                    }
                    case "lastIntervalProcessTime": {
                        temp_last_interval_process_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block38;
                    }
                    case "lastHandleTime": {
                        temp_last_handle_time = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block38;
                    }
                    case "consensusHeaderTreeRootHash": {
                        temp_consensus_header_tree_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"consensus_header_tree_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "traceDataTreeRootHash": {
                        temp_trace_data_tree_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"trace_data_tree_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                    case "outputTreeRootHash": {
                        temp_output_tree_root_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"output_tree_root_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block38;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockStreamInfo(temp_block_number, temp_block_time, temp_trailing_output_hashes, temp_trailing_block_hashes, temp_input_tree_root_hash, temp_start_of_block_state_hash, temp_num_preceding_state_changes_items, temp_rightmost_preceding_state_changes_tree_hashes, temp_block_end_time, temp_post_upgrade_work_done, temp_creation_software_version, temp_last_interval_process_time, temp_last_handle_time, temp_consensus_header_tree_root_hash, temp_trace_data_tree_root_hash, temp_output_tree_root_hash);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockStreamInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.blockNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"blockNumber", (long)data.blockNumber()));
        }
        if (data.blockTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockTime", Timestamp.JSON, (Object)data.blockTime()));
        }
        if (data.trailingOutputHashes() != Bytes.EMPTY && data.trailingOutputHashes() != null && data.trailingOutputHashes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"trailingOutputHashes", (Bytes)data.trailingOutputHashes()));
        }
        if (data.trailingBlockHashes() != Bytes.EMPTY && data.trailingBlockHashes() != null && data.trailingBlockHashes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"trailingBlockHashes", (Bytes)data.trailingBlockHashes()));
        }
        if (data.inputTreeRootHash() != Bytes.EMPTY && data.inputTreeRootHash() != null && data.inputTreeRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"inputTreeRootHash", (Bytes)data.inputTreeRootHash()));
        }
        if (data.startOfBlockStateHash() != Bytes.EMPTY && data.startOfBlockStateHash() != null && data.startOfBlockStateHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"startOfBlockStateHash", (Bytes)data.startOfBlockStateHash()));
        }
        if (data.numPrecedingStateChangesItems() != 0) {
            fieldLines.add(JsonTools.field((String)"numPrecedingStateChangesItems", (int)data.numPrecedingStateChangesItems()));
        }
        if (!data.rightmostPrecedingStateChangesTreeHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"rightmostPrecedingStateChangesTreeHashes", (FieldDefinition)BlockStreamInfoSchema.RIGHTMOST_PRECEDING_STATE_CHANGES_TREE_HASHES, data.rightmostPrecedingStateChangesTreeHashes()));
        }
        if (data.blockEndTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockEndTime", Timestamp.JSON, (Object)data.blockEndTime()));
        }
        if (data.postUpgradeWorkDone()) {
            fieldLines.add(JsonTools.field((String)"postUpgradeWorkDone", (boolean)data.postUpgradeWorkDone()));
        }
        if (data.creationSoftwareVersion() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"creationSoftwareVersion", SemanticVersion.JSON, (Object)data.creationSoftwareVersion()));
        }
        if (data.lastIntervalProcessTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"lastIntervalProcessTime", Timestamp.JSON, (Object)data.lastIntervalProcessTime()));
        }
        if (data.lastHandleTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"lastHandleTime", Timestamp.JSON, (Object)data.lastHandleTime()));
        }
        if (data.consensusHeaderTreeRootHash() != Bytes.EMPTY && data.consensusHeaderTreeRootHash() != null && data.consensusHeaderTreeRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"consensusHeaderTreeRootHash", (Bytes)data.consensusHeaderTreeRootHash()));
        }
        if (data.traceDataTreeRootHash() != Bytes.EMPTY && data.traceDataTreeRootHash() != null && data.traceDataTreeRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"traceDataTreeRootHash", (Bytes)data.traceDataTreeRootHash()));
        }
        if (data.outputTreeRootHash() != Bytes.EMPTY && data.outputTreeRootHash() != null && data.outputTreeRootHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"outputTreeRootHash", (Bytes)data.outputTreeRootHash()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

