/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.event.EventConsensusData;
import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.hiero.base.concurrent.interrupt.Uninterruptable;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Hashable;
import org.hiero.base.iterator.TypedIterator;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.EventMetadata;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.Transaction;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class PlatformEvent
implements ConsensusEvent,
Hashable {
    private static final EventConsensusData NO_CONSENSUS = new EventConsensusData(null, -1L);
    private final GossipEvent gossipEvent;
    private final EventMetadata metadata;
    private Instant timeReceived;
    private NodeId senderId;
    private EventConsensusData consensusData;
    private Instant consensusTimestamp = null;
    private final CountDownLatch prehandleCompleted = new CountDownLatch(1);
    private long nGen = 0L;

    public PlatformEvent(@NonNull UnsignedEvent unsignedEvent, @NonNull byte[] signature) {
        this(unsignedEvent, Bytes.wrap((byte[])signature));
    }

    public PlatformEvent(@NonNull UnsignedEvent unsignedEvent, @NonNull Bytes signature) {
        this(new GossipEvent(Objects.requireNonNull(unsignedEvent, "The unsignedEvent must not be null").getEventCore(), Objects.requireNonNull(signature, "The signature must not be null"), unsignedEvent.getTransactionsBytes(), unsignedEvent.getParents()), unsignedEvent.getMetadata());
    }

    public PlatformEvent(@NonNull GossipEvent gossipEvent) {
        this(Objects.requireNonNull(gossipEvent, "The gossipEvent must not be null"), new EventMetadata(gossipEvent));
    }

    private PlatformEvent(@NonNull GossipEvent gossipEvent, @NonNull EventMetadata metadata) {
        this.gossipEvent = gossipEvent;
        this.metadata = metadata;
        this.timeReceived = Instant.now();
        this.senderId = null;
        this.consensusData = NO_CONSENSUS;
        Objects.requireNonNull(gossipEvent.eventCore(), "The eventCore must not be null");
    }

    @NonNull
    public PlatformEvent copyGossipedData() {
        PlatformEvent platformEvent = new PlatformEvent(this.gossipEvent);
        platformEvent.setHash(this.getHash());
        return platformEvent;
    }

    @NonNull
    public GossipEvent getGossipEvent() {
        return this.gossipEvent;
    }

    @Override
    @NonNull
    public Bytes getSignature() {
        return this.gossipEvent.signature();
    }

    @NonNull
    public EventDescriptorWrapper getDescriptor() {
        return this.metadata.getDescriptor();
    }

    @Override
    public Iterator<Transaction> transactionIterator() {
        return new TypedIterator(this.metadata.getTransactions().iterator());
    }

    @Override
    public Instant getTimeCreated() {
        return this.metadata.getTimeCreated();
    }

    @Override
    @NonNull
    public EventCore getEventCore() {
        return this.gossipEvent.eventCoreOrThrow();
    }

    @Override
    @NonNull
    public NodeId getCreatorId() {
        return this.metadata.getCreatorId();
    }

    public long getNGen() {
        return this.nGen;
    }

    public boolean hasNGen() {
        return this.nGen != 0L;
    }

    public void setNGen(long nGen) {
        this.nGen = nGen;
    }

    @Override
    public long getBirthRound() {
        return this.metadata.getBirthRound();
    }

    public int getTransactionCount() {
        return this.metadata.getTransactions().size();
    }

    @NonNull
    public Instant getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(@NonNull Instant timeReceived) {
        this.timeReceived = timeReceived;
    }

    @Nullable
    public NodeId getSenderId() {
        return this.senderId;
    }

    public void setSenderId(@NonNull NodeId senderId) {
        this.senderId = senderId;
    }

    @Nullable
    public EventConsensusData getConsensusData() {
        return this.consensusData;
    }

    @Override
    @Nullable
    public Instant getConsensusTimestamp() {
        return this.consensusTimestamp;
    }

    @Override
    @NonNull
    public Iterator<ConsensusTransaction> consensusTransactionIterator() {
        return new TypedIterator(this.metadata.getTransactions().iterator());
    }

    @Override
    public long getConsensusOrder() {
        return this.consensusData.consensusOrder();
    }

    public void setConsensusData(@NonNull EventConsensusData consensusData) {
        if (this.consensusData != NO_CONSENSUS) {
            throw new IllegalStateException("Consensus data already set");
        }
        Objects.requireNonNull(consensusData, "consensusData");
        Objects.requireNonNull(consensusData.consensusTimestamp(), "consensusData.consensusTimestamp");
        this.consensusData = consensusData;
        this.consensusTimestamp = HapiUtils.asInstant((Timestamp)consensusData.consensusTimestamp());
    }

    public void setConsensusTimestampsOnTransactions() {
        if (this.consensusData == NO_CONSENSUS) {
            throw new IllegalStateException("Consensus data must be set");
        }
        for (int i = 0; i < this.metadata.getTransactions().size(); ++i) {
            this.metadata.getTransactions().get(i).setConsensusTimestamp(this.getTransactionTime(i));
        }
    }

    public List<TransactionWrapper> getTransactions() {
        return this.metadata.getTransactions();
    }

    @NonNull
    public Instant getTransactionTime(int transactionIndex) {
        if (this.consensusTimestamp == null) {
            throw new IllegalArgumentException("Event is not a consensus event");
        }
        if (transactionIndex >= this.getTransactionCount()) {
            throw new IllegalArgumentException("Event does not have a transaction with index: " + transactionIndex);
        }
        return this.consensusTimestamp.plusNanos((long)transactionIndex * 1000L);
    }

    public void signalPrehandleCompletion() {
        this.prehandleCompleted.countDown();
    }

    public void awaitPrehandleCompletion() {
        Uninterruptable.abortAndLogIfInterrupted(this.prehandleCompleted::await, (String)"interrupted while waiting for prehandle completion");
    }

    @Nullable
    public EventDescriptorWrapper getSelfParent() {
        return this.metadata.getSelfParent();
    }

    @NonNull
    public List<EventDescriptorWrapper> getOtherParents() {
        return this.metadata.getOtherParents();
    }

    public boolean hasOtherParents() {
        return this.metadata.hasOtherParents();
    }

    @NonNull
    public List<EventDescriptorWrapper> getAllParents() {
        return this.metadata.getAllParents();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDescriptor());
        stringBuilder.append("\n");
        stringBuilder.append("    sp: ");
        EventDescriptorWrapper selfParent = this.getSelfParent();
        if (selfParent != null) {
            stringBuilder.append(selfParent);
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("\n");
        int otherParentCount = 0;
        for (EventDescriptorWrapper otherParent : this.getOtherParents()) {
            stringBuilder.append("    op");
            stringBuilder.append(otherParentCount);
            stringBuilder.append(": ");
            stringBuilder.append(otherParent);
            if (++otherParentCount == this.getOtherParents().size()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformEvent that = (PlatformEvent)o;
        return Objects.equals(this.gossipEvent, that.gossipEvent) && Objects.equals(this.consensusData, that.consensusData);
    }

    public boolean equalsGossipedData(@NonNull PlatformEvent that) {
        return Objects.equals(this.getEventCore(), that.getEventCore()) && Objects.equals(this.getSignature(), that.getSignature());
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    @Override
    @Nullable
    public Hash getHash() {
        return this.metadata.getHash();
    }

    @Override
    @NonNull
    public Iterator<EventDescriptorWrapper> allParentsIterator() {
        return new TypedIterator(this.metadata.getAllParents().iterator());
    }

    public void setHash(Hash hash) {
        this.metadata.setHash(hash);
    }
}

