/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteFloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.ByteFloatPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteFloatProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ByteFloatHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

final class ImmutableByteFloatHashMap
implements ImmutableByteFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteFloatMap delegate;

    ImmutableByteFloatHashMap(ByteFloatMap delegate) {
        this.delegate = new ByteFloatHashMap(delegate);
    }

    public float get(byte key) {
        return this.delegate.get(key);
    }

    public float getIfAbsent(byte key, float ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public float getOrThrow(byte key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(byte key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(float value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(FloatProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteFloatProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public boolean allSatisfyKeyValue(ByteFloatPredicate predicate) {
        return this.delegate.allSatisfyKeyValue(predicate);
    }

    public LazyByteIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ByteFloatPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatByteMap flipUniqueValues() {
        MutableFloatByteMap result = FloatByteMaps.mutable.empty();
        this.forEachKeyValue((ByteFloatProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableByteFloatMap select(ByteFloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteFloatMap reject(ByteFloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableFloatIterator iterator = this.delegate.floatIterator();
            while (iterator.hasNext()) {
                MutableFloatBag batch = FloatBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableByteFloatMap toImmutable() {
        return this;
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator((FloatIterator)this.delegate.floatIterator());
    }

    public void each(FloatProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableFloatBag select(FloatPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public double sum() {
        return this.delegate.sum();
    }

    public float max() {
        return this.delegate.max();
    }

    public float maxIfEmpty(float defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public float min() {
        return this.delegate.min();
    }

    public float minIfEmpty(float defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public float[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableFloatList toSortedList() {
        return this.delegate.toSortedList();
    }

    public float[] toArray() {
        return this.delegate.toArray();
    }

    public float[] toArray(float[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(float value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableFloatList toList() {
        return this.delegate.toList();
    }

    public MutableFloatSet toSet() {
        return this.delegate.toSet();
    }

    public MutableFloatBag toBag() {
        return this.delegate.toBag();
    }

    public LazyFloatIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableByteFloatMap newWithKeyValue(byte key, float value) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size() + 1);
        map.putAll((ByteFloatMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableByteFloatMap newWithoutKey(byte key) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size());
        map.putAll((ByteFloatMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableByteFloatMap newWithoutAllKeys(ByteIterable keys) {
        ByteFloatHashMap map = new ByteFloatHashMap(this.size());
        map.putAll((ByteFloatMap)this);
        ByteIterator iterator = keys.byteIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.delegate.keySet());
    }

    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableByteFloatMapSerializationProxy((ByteFloatMap)this);
    }

    protected static class ImmutableByteFloatMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ByteFloatMap map;

        public ImmutableByteFloatMapSerializationProxy() {
        }

        protected ImmutableByteFloatMapSerializationProxy(ByteFloatMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ByteFloatProcedure)new CheckedByteFloatProcedure(){

                    @Override
                    public void safeValue(byte key, float value) throws IOException {
                        out.writeByte(key);
                        out.writeFloat(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ByteFloatHashMap deserializedMap = new ByteFloatHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readByte(), in.readFloat());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

