/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hiero.block.api.codec.BlockContentsProofRequestJsonCodec;
import org.hiero.block.api.codec.BlockContentsProofRequestProtoCodec;
import org.hiero.block.api.schema.BlockContentsProofRequestSchema;

public final class BlockContentsProofRequest {
    public static final Codec<BlockContentsProofRequest> PROTOBUF = new BlockContentsProofRequestProtoCodec();
    public static final JsonCodec<BlockContentsProofRequest> JSON = new BlockContentsProofRequestJsonCodec();
    public static final BlockContentsProofRequest DEFAULT = BlockContentsProofRequest.newBuilder().build();
    private final long blockNumber;
    private final OneOf<BlockItemOneOfType> blockItem;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockContentsProofRequest(long blockNumber, OneOf<BlockItemOneOfType> blockItem) {
        this.$unknownFields = null;
        this.blockNumber = blockNumber;
        if (blockItem == null) {
            throw new NullPointerException("Parameter 'blockItem' must be supplied and can not be null");
        }
        this.blockItem = blockItem;
    }

    public BlockContentsProofRequest(long blockNumber, OneOf<BlockItemOneOfType> blockItem, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.blockNumber = blockNumber;
        if (blockItem == null) {
            throw new NullPointerException("Parameter 'blockItem' must be supplied and can not be null");
        }
        this.blockItem = blockItem;
    }

    public long blockNumber() {
        return this.blockNumber;
    }

    public OneOf<BlockItemOneOfType> blockItem() {
        return this.blockItem;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockContentsProofRequestSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
            if (this.blockItem.kind() == BlockItemOneOfType.COMPLETE_BLOCK_ITEM) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockContentsProofRequestSchema.COMPLETE_BLOCK_ITEM, (Object)((BlockItem)this.blockItem.as()), BlockItem.PROTOBUF);
            }
            if (this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_HASH) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockContentsProofRequestSchema.BLOCK_ITEM_HASH, (RandomAccessData)((RandomAccessData)this.blockItem.as()), (boolean)true);
            }
            if (this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_INDEX) {
                _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)BlockContentsProofRequestSchema.BLOCK_ITEM_INDEX, (int)((Integer)this.blockItem.as()), (boolean)true);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.blockNumber != BlockContentsProofRequest.DEFAULT.blockNumber) {
                result = 31 * result + Long.hashCode(this.blockNumber);
            }
            if (this.blockItem != null && !this.blockItem.equals(BlockContentsProofRequest.DEFAULT.blockItem)) {
                result = 31 * result + this.blockItem.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockContentsProofRequest thatObj = (BlockContentsProofRequest)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.blockNumber != thatObj.blockNumber) {
            return false;
        }
        if (this.blockItem == null && thatObj.blockItem != null) {
            return false;
        }
        if (this.blockItem != null && !this.blockItem.equals(thatObj.blockItem)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockContentsProofRequest[blockNumber=" + this.blockNumber + ", blockItem=" + String.valueOf(this.blockItem) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public BlockItem completeBlockItem() {
        return this.blockItem.kind() == BlockItemOneOfType.COMPLETE_BLOCK_ITEM ? (BlockItem)this.blockItem.value() : null;
    }

    public boolean hasCompleteBlockItem() {
        return this.blockItem.kind() == BlockItemOneOfType.COMPLETE_BLOCK_ITEM;
    }

    public BlockItem completeBlockItemOrElse(@NonNull BlockItem defaultValue) {
        return this.hasCompleteBlockItem() ? this.completeBlockItem() : defaultValue;
    }

    @NonNull
    public BlockItem completeBlockItemOrThrow() {
        return Objects.requireNonNull(this.completeBlockItem(), "Field completeBlockItem is null");
    }

    @Nullable
    public Bytes blockItemHash() {
        return this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_HASH ? (Bytes)this.blockItem.value() : null;
    }

    public boolean hasBlockItemHash() {
        return this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_HASH;
    }

    public Bytes blockItemHashOrElse(@NonNull Bytes defaultValue) {
        return this.hasBlockItemHash() ? this.blockItemHash() : defaultValue;
    }

    @NonNull
    public Bytes blockItemHashOrThrow() {
        return Objects.requireNonNull(this.blockItemHash(), "Field blockItemHash is null");
    }

    @Nullable
    public Integer blockItemIndex() {
        return this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_INDEX ? (Integer)this.blockItem.value() : null;
    }

    public boolean hasBlockItemIndex() {
        return this.blockItem.kind() == BlockItemOneOfType.BLOCK_ITEM_INDEX;
    }

    public Integer blockItemIndexOrElse(@NonNull Integer defaultValue) {
        return this.hasBlockItemIndex() ? this.blockItemIndex() : defaultValue;
    }

    @NonNull
    public Integer blockItemIndexOrThrow() {
        return Objects.requireNonNull(this.blockItemIndex(), "Field blockItemIndex is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.blockNumber, this.blockItem, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum BlockItemOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        COMPLETE_BLOCK_ITEM(2, "complete_block_item"),
        BLOCK_ITEM_HASH(3, "block_item_hash"),
        BLOCK_ITEM_INDEX(4, "block_item_index");

        private final int protoOrdinal;
        private final String protoName;

        private BlockItemOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static BlockItemOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 2 -> COMPLETE_BLOCK_ITEM;
                case 3 -> BLOCK_ITEM_HASH;
                case 4 -> BLOCK_ITEM_INDEX;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static BlockItemOneOfType fromString(String name) {
            return switch (name) {
                case "complete_block_item", "COMPLETE_BLOCK_ITEM" -> COMPLETE_BLOCK_ITEM;
                case "block_item_hash", "BLOCK_ITEM_HASH" -> BLOCK_ITEM_HASH;
                case "block_item_index", "BLOCK_ITEM_INDEX" -> BLOCK_ITEM_INDEX;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private long blockNumber = 0L;
        private OneOf<BlockItemOneOfType> blockItem = BlockContentsProofRequestProtoCodec.BLOCK_ITEM_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(long blockNumber, OneOf<BlockItemOneOfType> blockItem) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
            this.blockItem = blockItem;
        }

        public Builder(long blockNumber, OneOf<BlockItemOneOfType> blockItem, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
            this.blockItem = blockItem;
        }

        public BlockContentsProofRequest build() {
            return new BlockContentsProofRequest(this.blockNumber, this.blockItem);
        }

        public Builder blockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public Builder completeBlockItem(@Nullable BlockItem completeBlockItem) {
            this.blockItem = new OneOf((Enum)BlockItemOneOfType.COMPLETE_BLOCK_ITEM, (Object)completeBlockItem);
            return this;
        }

        public Builder completeBlockItem(BlockItem.Builder builder) {
            this.blockItem = new OneOf((Enum)BlockItemOneOfType.COMPLETE_BLOCK_ITEM, (Object)builder.build());
            return this;
        }

        public Builder blockItemHash(@NonNull Bytes blockItemHash) {
            this.blockItem = new OneOf((Enum)BlockItemOneOfType.BLOCK_ITEM_HASH, (Object)blockItemHash);
            return this;
        }

        public Builder blockItemIndex(int blockItemIndex) {
            this.blockItem = new OneOf((Enum)BlockItemOneOfType.BLOCK_ITEM_INDEX, (Object)blockItemIndex);
            return this;
        }
    }
}

